/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.ComponentEventHandler;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.internal.services.EventImpl;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.services.TypeCoercer;
import org.apache.tapestry.runtime.ComponentEvent;

public class ComponentEventImpl
extends EventImpl
implements ComponentEvent {
    private final String _eventType;
    private final String _originatingComponentId;
    private final Object[] _context;
    private final TypeCoercer _typeCoercer;

    public ComponentEventImpl(String eventType, String originatingComponentId, Object[] context, ComponentEventHandler handler, TypeCoercer typeCoercer) {
        super(handler);
        this._eventType = Defense.notBlank((String)eventType, (String)"eventType");
        this._originatingComponentId = originatingComponentId;
        this._context = context != null ? context : new Object[]{};
        this._typeCoercer = (TypeCoercer)Defense.notNull((Object)typeCoercer, (String)"typeCoercer");
    }

    public boolean matchesByComponentId(ComponentResources resources, String[] componentId) {
        for (String id : componentId) {
            if (!id.equalsIgnoreCase(this._originatingComponentId)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesByEventType(String[] eventTypes) {
        for (String type : eventTypes) {
            if (!type.equalsIgnoreCase(this._eventType)) continue;
            return true;
        }
        return false;
    }

    public Object coerceContext(int index, String desiredTypeName) {
        if (index >= this._context.length) {
            throw new IllegalArgumentException(ServicesMessages.contextIndexOutOfRange(this.getMethodDescription()));
        }
        try {
            Class<?> desiredType = Class.forName(desiredTypeName);
            return this._typeCoercer.coerce(this._context[index], desiredType);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ServicesMessages.exceptionInMethodParameter(this.getMethodDescription(), index, ex), ex);
        }
    }

    public Object[] getContext() {
        return this._context;
    }
}

