/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.commons.logging.Log;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.Link;
import org.apache.tapestry.internal.services.LinkActionResponseGenerator;
import org.apache.tapestry.internal.services.LinkFactory;
import org.apache.tapestry.internal.services.RequestPageCache;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.ActionResponseGenerator;
import org.apache.tapestry.services.ComponentEventResultProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentInstanceResultProcessor
implements ComponentEventResultProcessor<Component> {
    private final RequestPageCache _requestPageCache;
    private final LinkFactory _linkFactory;
    private final Log _log;

    public ComponentInstanceResultProcessor(RequestPageCache requestPageCache, LinkFactory linkFactory, Log log) {
        this._requestPageCache = requestPageCache;
        this._linkFactory = linkFactory;
        this._log = log;
    }

    @Override
    public ActionResponseGenerator processComponentEvent(Component value, Component component, String methodDescription) {
        ComponentResources resources = value.getComponentResources();
        if (resources.getContainer() != null) {
            this._log.warn((Object)ServicesMessages.componentInstanceIsNotAPage(methodDescription, component, value));
            resources = resources.getPage().getComponentResources();
        }
        String pageClassName = resources.getCompleteId();
        Page page = this._requestPageCache.getByClassName(pageClassName);
        Link link = this._linkFactory.createPageLink(page);
        return new LinkActionResponseGenerator(link);
    }
}

