/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.net.URL;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.Loader;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.Translator;
import org.apache.commons.logging.Log;
import org.apache.tapestry.events.UpdateListener;
import org.apache.tapestry.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry.internal.services.ComponentClassTransformer;
import org.apache.tapestry.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry.internal.services.Instantiator;
import org.apache.tapestry.internal.util.URLChangeTracker;
import org.apache.tapestry.ioc.internal.services.ClassFactoryClassPool;
import org.apache.tapestry.ioc.internal.services.ClassFactoryImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.services.ClassFactory;

public final class ComponentInstantiatorSourceImpl
extends InvalidationEventHubImpl
implements Translator,
ComponentInstantiatorSource,
UpdateListener {
    private final Set<String> _controlledPackageNames = CollectionFactory.newSet();
    private final URLChangeTracker _changeTracker = new URLChangeTracker();
    private final ClassLoader _parent;
    private ClassFactoryClassPool _classPool;
    private Loader _loader;
    private final ComponentClassTransformer _transformer;
    private final Log _log;
    private ClassFactory _classFactory;
    private final Map<String, Instantiator> _instantiatorMap = CollectionFactory.newMap();

    public ComponentInstantiatorSourceImpl(ClassLoader parent, ComponentClassTransformer transformer, Log log) {
        this._parent = parent;
        this._transformer = transformer;
        this._log = log;
        this.initializeService();
    }

    public synchronized void checkForUpdates() {
        if (!this._changeTracker.containsChanges()) {
            return;
        }
        this._changeTracker.clear();
        this._instantiatorMap.clear();
        this.initializeService();
        this.fireInvalidationEvent();
    }

    private void initializeService() {
        this._classPool = new ClassFactoryClassPool(this._parent);
        this._loader = new PackageAwareLoader(this._parent, (ClassPool)this._classPool);
        LoaderClassPath path = new LoaderClassPath((ClassLoader)this._loader);
        this._classPool.appendClassPath((ClassPath)path);
        try {
            this._loader.addTranslator((ClassPool)this._classPool, (Translator)this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this._classFactory = new ClassFactoryImpl(this._classPool.getLoader(), this._classPool, this._log);
    }

    public void onLoad(ClassPool pool, String classname) throws NotFoundException, CannotCompileException {
        this._log.debug((Object)("BEGIN onLoad " + classname));
        String diag = "FAIL";
        this.addClassFileToChangeTracker(classname);
        try {
            CtClass ctClass = pool.get(classname);
            this.forceSuperclassTransform(ctClass);
            this._transformer.transformComponentClass(ctClass, (ClassLoader)this._loader);
            diag = "END";
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new CannotCompileException((Throwable)ex);
            }
            catch (Throwable throwable) {
                this._log.debug((Object)String.format("%5s onLoad %s", diag, classname));
                throw throwable;
            }
        }
        this._log.debug((Object)String.format("%5s onLoad %s", diag, classname));
    }

    private void addClassFileToChangeTracker(String classname) {
        String path = classname.replace('.', '/') + ".class";
        URL url = this._loader.getResource(path);
        this._changeTracker.add(url);
    }

    private void forceSuperclassTransform(CtClass ctClass) throws NotFoundException, ClassNotFoundException {
        CtClass superClass = ctClass.getSuperclass();
        this.findClass(superClass.getName());
    }

    public void start(ClassPool pool) throws NotFoundException, CannotCompileException {
    }

    public synchronized Instantiator findInstantiator(String classname) {
        Instantiator result = this._instantiatorMap.get(classname);
        if (result == null) {
            Class instanceClass = this.findClass(classname);
            result = this._transformer.createInstantiator(instanceClass);
            this._instantiatorMap.put(classname, result);
        }
        return result;
    }

    private Class findClass(String classname) {
        try {
            return this._loader.loadClass(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    boolean inControlledPackage(String classname) {
        String packageName = this.stripTail(classname);
        while (packageName != null) {
            if (this._controlledPackageNames.contains(packageName)) {
                return true;
            }
            packageName = this.stripTail(packageName);
        }
        return false;
    }

    private String stripTail(String input) {
        int lastdot = input.lastIndexOf(46);
        if (lastdot < 0) {
            return null;
        }
        return input.substring(0, lastdot);
    }

    public synchronized void addPackage(String packageName) {
        Defense.notBlank((String)packageName, (String)"packageName");
        this._controlledPackageNames.add(packageName);
    }

    public boolean exists(String className) {
        String path = className.replace(".", "/") + ".class";
        return this._parent.getResource(path) != null;
    }

    public ClassFactory getClassFactory() {
        return this._classFactory;
    }

    private class PackageAwareLoader
    extends Loader {
        public PackageAwareLoader(ClassLoader parent, ClassPool classPool) {
            super(parent, classPool);
        }

        protected Class findClass(String className) throws ClassNotFoundException {
            if (ComponentInstantiatorSourceImpl.this.inControlledPackage(className)) {
                return super.findClass(className);
            }
            return null;
        }
    }
}

