/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import java.util.Map;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.tapestry.internal.services.InvocationTarget;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentInvocation {
    private final Object[] _context;
    private Map<String, String> _parameters;
    private InvocationTarget _target;

    public ComponentInvocation(InvocationTarget target, Object[] context) {
        this._target = target;
        this._context = context;
    }

    public String buildURI(boolean isForm) {
        String path = this.getPath();
        if (isForm || this._parameters == null) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(path);
        try {
            URLCodec codec = new URLCodec();
            String sep = "?";
            for (String name : this.getParameterNames()) {
                String value = this._parameters.get(name);
                builder.append(sep);
                builder.append(name);
                builder.append("=");
                builder.append(codec.encode(value));
                sep = "&";
            }
        }
        catch (EncoderException ex) {
            throw new RuntimeException(ex);
        }
        return builder.toString();
    }

    private String getPath() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._target.getPath());
        for (Object id : this._context) {
            builder.append("/");
            builder.append(id.toString());
        }
        return builder.toString();
    }

    public Object[] getContext() {
        return this._context;
    }

    public void addParameter(String parameterName, String value) {
        if (this._parameters == null) {
            this._parameters = CollectionFactory.newMap();
        }
        if (this._parameters.containsKey(parameterName)) {
            throw new IllegalArgumentException(ServicesMessages.parameterNameMustBeUnique(parameterName, this._parameters.get(parameterName)));
        }
        this._parameters.put(parameterName, value);
    }

    public List<String> getParameterNames() {
        return InternalUtils.sortedKeys(this._parameters);
    }

    public String getParameterValue(String name) {
        return (String)InternalUtils.get(this._parameters, (Object)name);
    }

    public InvocationTarget getTarget() {
        return this._target;
    }
}

