/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.events.UpdateListener;
import org.apache.tapestry.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry.internal.parser.ComponentTemplate;
import org.apache.tapestry.internal.parser.TemplateToken;
import org.apache.tapestry.internal.services.ComponentTemplateSource;
import org.apache.tapestry.internal.services.PageTemplateLocator;
import org.apache.tapestry.internal.services.TemplateParser;
import org.apache.tapestry.internal.util.MultiKey;
import org.apache.tapestry.internal.util.URLChangeTracker;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.model.ComponentModel;

public final class ComponentTemplateSourceImpl
extends InvalidationEventHubImpl
implements ComponentTemplateSource,
UpdateListener {
    private final TemplateParser _parser;
    private final PageTemplateLocator _locator;
    private final URLChangeTracker _tracker;
    private final Map<MultiKey, Resource> _templateResources = CollectionFactory.newThreadSafeMap();
    private final Map<Resource, ComponentTemplate> _templates = CollectionFactory.newThreadSafeMap();
    private final ComponentTemplate _missingTemplate = new ComponentTemplate(){

        @Override
        public Set<String> getComponentIds() {
            return null;
        }

        @Override
        public Resource getResource() {
            return null;
        }

        @Override
        public List<TemplateToken> getTokens() {
            return null;
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    };

    public ComponentTemplateSourceImpl(TemplateParser parser, PageTemplateLocator locator) {
        this(parser, locator, new URLChangeTracker());
    }

    ComponentTemplateSourceImpl(TemplateParser parser, PageTemplateLocator locator, URLChangeTracker tracker) {
        this._parser = parser;
        this._locator = locator;
        this._tracker = tracker;
    }

    public ComponentTemplate getTemplate(ComponentModel componentModel, Locale locale) {
        ComponentTemplate result;
        String componentName = componentModel.getComponentClassName();
        MultiKey key = new MultiKey(componentName, locale);
        Resource resource = this._templateResources.get(key);
        if (resource == null) {
            resource = this.locateTemplateResource(componentModel, locale);
            this._templateResources.put(key, resource);
        }
        if ((result = this._templates.get(resource)) == null) {
            result = this.parseTemplate(resource);
            this._templates.put(resource, result);
        }
        return result;
    }

    private ComponentTemplate parseTemplate(Resource r) {
        URL resourceURL = r.toURL();
        if (resourceURL == null) {
            return this._missingTemplate;
        }
        this._tracker.add(resourceURL);
        return this._parser.parseTemplate(r);
    }

    private Resource locateTemplateResource(ComponentModel initialModel, Locale locale) {
        for (ComponentModel model = initialModel; model != null; model = model.getParentModel()) {
            Resource baseResource = this.baseResourceForModel(model);
            Resource localized = baseResource.forLocale(locale);
            if (localized != null) {
                return localized;
            }
            localized = this._locator.findPageTemplateResource(model, locale);
            if (localized == null) continue;
            return localized;
        }
        return this.baseResourceForModel(initialModel);
    }

    private Resource baseResourceForModel(ComponentModel model) {
        return model.getBaseResource().withExtension("html");
    }

    public void checkForUpdates() {
        if (this._tracker.containsChanges()) {
            this._tracker.clear();
            this._templateResources.clear();
            this._templates.clear();
            this.fireInvalidationEvent();
        }
    }
}

