/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.annotations.Component;
import org.apache.tapestry.annotations.MixinClasses;
import org.apache.tapestry.annotations.Mixins;
import org.apache.tapestry.internal.KeyValue;
import org.apache.tapestry.internal.TapestryUtils;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.model.MutableEmbeddedComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassResolver;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.TransformConstants;

public class ComponentWorker
implements ComponentClassTransformWorker {
    private final ComponentClassResolver _resolver;

    public ComponentWorker(ComponentClassResolver resolver) {
        this._resolver = resolver;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        for (String fieldName : transformation.findFieldsWithAnnotation(Component.class)) {
            Component annotation = transformation.getFieldAnnotation(fieldName, Component.class);
            String id = annotation.id();
            if (InternalUtils.isBlank((String)id)) {
                id = InternalUtils.stripMemberPrefix((String)fieldName);
            }
            String type = transformation.getFieldType(fieldName);
            MutableEmbeddedComponentModel embedded = model.addEmbeddedComponent(id, annotation.type(), type);
            this.addParameters(embedded, annotation.parameters());
            transformation.makeReadOnly(fieldName);
            String body = String.format("%s = (%s) %s.getEmbeddedComponent(\"%s\");", fieldName, type, transformation.getResourcesFieldName(), id);
            transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, body);
            this.addMixinClasses(fieldName, transformation, embedded);
            this.addMixinTypes(fieldName, transformation, embedded);
            transformation.claimField(fieldName, annotation);
        }
    }

    private void addMixinClasses(String fieldName, ClassTransformation transformation, MutableEmbeddedComponentModel model) {
        MixinClasses annotation = transformation.getFieldAnnotation(fieldName, MixinClasses.class);
        if (annotation == null) {
            return;
        }
        for (Class c : annotation.value()) {
            model.addMixin(c.getName());
        }
    }

    private void addMixinTypes(String fieldName, ClassTransformation transformation, MutableEmbeddedComponentModel model) {
        Mixins annotation = transformation.getFieldAnnotation(fieldName, Mixins.class);
        if (annotation == null) {
            return;
        }
        for (String typeName : annotation.value()) {
            String mixinClassName = this._resolver.resolveMixinTypeToClassName(typeName);
            model.addMixin(mixinClassName);
        }
    }

    private void addParameters(MutableEmbeddedComponentModel embedded, String[] parameters) {
        for (String parameter : parameters) {
            KeyValue kv = TapestryUtils.parseKeyValue(parameter);
            embedded.addParameter(kv.getKey(), kv.getValue());
        }
    }
}

