/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import javax.servlet.http.Cookie;
import org.apache.tapestry.internal.services.ContextPathSource;
import org.apache.tapestry.internal.services.CookieSink;
import org.apache.tapestry.internal.services.CookieSource;
import org.apache.tapestry.services.Cookies;

public class CookiesImpl
implements Cookies {
    private ContextPathSource _contextPathSource;
    private CookieSource _cookieSource;
    private CookieSink _cookieSink;
    private int _defaultMaxAge;

    public CookiesImpl(ContextPathSource contextPathSource, CookieSource cookieSource, CookieSink cookieSink, int defaultMaxAge) {
        this._contextPathSource = contextPathSource;
        this._cookieSource = cookieSource;
        this._cookieSink = cookieSink;
        this._defaultMaxAge = defaultMaxAge;
    }

    public String readCookieValue(String name) {
        Cookie[] cookies = this._cookieSource.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public void writeCookieValue(String name, String value) {
        this.writeCookieValue(name, value, this._defaultMaxAge);
    }

    public void writeCookieValue(String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this._contextPathSource.getContextPath() + "/");
        cookie.setMaxAge(maxAge);
        this._cookieSink.addCookie(cookie);
    }

    public void writeCookieValue(String name, String value, String path) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        this._cookieSink.addCookie(cookie);
    }

    public void writeDomainCookieValue(String name, String value, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this._contextPathSource.getContextPath() + "/");
        cookie.setDomain(domain);
        this._cookieSink.addCookie(cookie);
    }

    public void writeDomainCookieValue(String name, String value, String domain, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this._contextPathSource.getContextPath() + "/");
        cookie.setDomain(domain);
        cookie.setMaxAge(maxAge);
        this._cookieSink.addCookie(cookie);
    }

    public void writeCookieValue(String name, String value, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setDomain(domain);
        this._cookieSink.addCookie(cookie);
    }

    public void removeCookieValue(String name) {
        Cookie cookie = new Cookie(name, null);
        cookie.setPath(this._contextPathSource.getContextPath() + "/");
        cookie.setMaxAge(0);
        this._cookieSink.addCookie(cookie);
    }
}

