/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Locale;
import org.apache.tapestry.AnnotationProvider;
import org.apache.tapestry.Field;
import org.apache.tapestry.FieldValidator;
import org.apache.tapestry.internal.services.FieldValidatorDefaultSourceImpl;
import org.apache.tapestry.internal.test.InternalBaseTestCase;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.services.FieldValidatorSource;
import org.apache.tapestry.services.ValidationConstraintGenerator;
import org.testng.annotations.Test;

public class FieldValidatorDefaultSourceImplTest
extends InternalBaseTestCase {
    @Test
    public void invokes_all_constraint_generators() throws Exception {
        this.getMocksControl().checkOrder(true);
        ValidationConstraintGenerator gen = this.newValidationConstraintGenerator();
        FieldValidator fv1 = this.newFieldValidator();
        FieldValidator fv2 = this.newFieldValidator();
        FieldValidatorSource source = this.newFieldValidatorSource();
        Class<Integer> propertyType = Integer.class;
        AnnotationProvider provider = this.newAnnotationProvider();
        String overrideId = "overrideId";
        Messages overrideMessages = this.newMessages();
        Field field = this.newField();
        Locale locale = Locale.ENGLISH;
        String value = "*VALUE*";
        this.train_buildConstraints(gen, propertyType, provider, "cons1", "cons2");
        this.train_createValidator(source, field, "cons1", null, overrideId, overrideMessages, locale, fv1);
        this.train_createValidator(source, field, "cons2", null, overrideId, overrideMessages, locale, fv2);
        fv1.validate(value);
        fv2.validate(value);
        this.replay();
        FieldValidatorDefaultSourceImpl fieldValidatorSource = new FieldValidatorDefaultSourceImpl(gen, source);
        FieldValidator composite = fieldValidatorSource.createDefaultValidator(field, overrideId, overrideMessages, locale, propertyType, provider);
        composite.validate(value);
        this.verify();
    }

    @Test
    public void validator_with_constraint() throws Exception {
        ValidationConstraintGenerator gen = this.newValidationConstraintGenerator();
        FieldValidator fv = this.newFieldValidator();
        FieldValidatorSource source = this.newFieldValidatorSource();
        Class<Integer> propertyType = Integer.class;
        AnnotationProvider provider = this.newAnnotationProvider();
        String overrideId = "overrideId";
        Messages overrideMessages = this.newMessages();
        Field field = this.newField();
        Locale locale = Locale.ENGLISH;
        this.train_buildConstraints(gen, propertyType, provider, "foo=bar");
        this.train_createValidator(source, field, "foo", "bar", overrideId, overrideMessages, locale, fv);
        this.replay();
        FieldValidatorDefaultSourceImpl fieldValidatorSource = new FieldValidatorDefaultSourceImpl(gen, source);
        FieldValidator composite = fieldValidatorSource.createDefaultValidator(field, overrideId, overrideMessages, locale, propertyType, provider);
        FieldValidatorDefaultSourceImplTest.assertSame((Object)composite, (Object)fv);
        this.verify();
    }

    @Test
    public void no_validators_at_all() throws Exception {
        ValidationConstraintGenerator gen = this.newValidationConstraintGenerator();
        FieldValidatorSource source = this.newFieldValidatorSource();
        Class<Integer> propertyType = Integer.class;
        AnnotationProvider provider = this.newAnnotationProvider();
        String overrideId = "overrideId";
        Messages overrideMessages = this.newMessages();
        Field field = this.newField();
        Locale locale = Locale.ENGLISH;
        String value = "*VALUE*";
        this.train_buildConstraints(gen, propertyType, provider, new String[0]);
        this.replay();
        FieldValidatorDefaultSourceImpl fieldValidatorSource = new FieldValidatorDefaultSourceImpl(gen, source);
        FieldValidator composite = fieldValidatorSource.createDefaultValidator(field, overrideId, overrideMessages, locale, propertyType, provider);
        composite.validate(value);
        this.verify();
    }
}

