/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.InfrastructureContribution;
import org.apache.tapestry.services.InfrastructureManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfrastructureManagerImpl
implements InfrastructureManager {
    private final Log _log;
    private final Collection<InfrastructureContribution> _contributions;

    public InfrastructureManagerImpl(Log log, Collection<InfrastructureContribution> contributions) {
        this._log = log;
        this._contributions = contributions;
    }

    @Override
    public Map<String, Object> getContributionsForMode(String mode) {
        Map<String, Object> general = this.buildMapForMode("");
        Map<String, Object> specific = this.buildMapForMode(mode);
        general.putAll(specific);
        return general;
    }

    private Map<String, Object> buildMapForMode(String mode) {
        Map result = CollectionFactory.newMap();
        for (InfrastructureContribution ic : this._contributions) {
            if (!ic.getMode().equals(mode)) continue;
            String name = ic.getName();
            Object existing = result.get(name);
            if (existing != null) {
                this._log.warn((Object)ServicesMessages.duplicateContribution(ic.getObject(), name, existing));
                continue;
            }
            result.put(name, ic.getObject());
        }
        return result;
    }
}

