/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.InjectionProvider;

public class InjectAnonymousWorker
implements ComponentClassTransformWorker {
    private final ServiceLocator _locator;
    private final InjectionProvider _injectionProvider;

    public InjectAnonymousWorker(ServiceLocator locator, InjectionProvider injectionProvider) {
        this._locator = locator;
        this._injectionProvider = injectionProvider;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        for (String fieldName : transformation.findFieldsWithAnnotation(Inject.class)) {
            Inject annotation = transformation.getFieldAnnotation(fieldName, Inject.class);
            String fieldType = transformation.getFieldType(fieldName);
            boolean result = this._injectionProvider.provideInjection(fieldName, fieldType, this._locator, transformation, model);
            if (!result) {
                throw new RuntimeException(ServicesMessages.noInjectionFound(transformation.getClassName(), fieldName, fieldType));
            }
            transformation.claimField(fieldName, annotation);
        }
    }
}

