/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.annotations.InjectComponent;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.TransformConstants;

public class InjectComponentWorker
implements ComponentClassTransformWorker {
    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        List<String> names = transformation.findFieldsWithAnnotation(InjectComponent.class);
        if (names.isEmpty()) {
            return;
        }
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("%s core = %s.getCoreComponent();", new Object[]{Component.class.getName(), transformation.getResourcesFieldName()});
        for (String fieldName : names) {
            InjectComponent annotation = transformation.getFieldAnnotation(fieldName, InjectComponent.class);
            String fieldType = transformation.getFieldType(fieldName);
            builder.addln("try", new Object[0]);
            builder.begin();
            builder.addln("%s = (%s) core;", new Object[]{fieldName, fieldType});
            builder.end();
            builder.addln("catch (ClassCastException ex)", new Object[0]);
            builder.begin();
            builder.addln("String message = %s.buildCastExceptionMessage(core, \"%s.%s\", \"%s\");", new Object[]{InjectComponentWorker.class.getName(), model.getComponentClassName(), fieldName, fieldType});
            builder.addln("throw new RuntimeException(message, ex);", new Object[0]);
            builder.end();
            transformation.makeReadOnly(fieldName);
            transformation.claimField(fieldName, annotation);
        }
        builder.end();
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, builder.toString());
    }

    public static String buildCastExceptionMessage(Component component, String fieldName, String fieldType) {
        return ServicesMessages.componentNotAssignableToField(component, fieldName, fieldType);
    }
}

