/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.internal.InternalComponentResources;
import org.apache.tapestry.internal.services.ConstructorArg;
import org.apache.tapestry.internal.services.Instantiator;
import org.apache.tapestry.internal.services.InternalClassTransformation;
import org.apache.tapestry.internal.services.MethodCompileException;
import org.apache.tapestry.internal.services.ReflectiveInstantiator;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.internal.util.MultiKey;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.IdAllocator;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.FieldFilter;
import org.apache.tapestry.services.MethodFilter;
import org.apache.tapestry.services.MethodSignature;
import org.apache.tapestry.services.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalClassTransformationImpl
implements InternalClassTransformation {
    private boolean _frozen;
    private final CtClass _ctClass;
    private final Log _log;
    private final InternalClassTransformation _parentTransformation;
    private ClassPool _classPool;
    private final IdAllocator _idAllocator;
    private final Map<MultiKey, String> _injectionCache = CollectionFactory.newMap();
    private Map<String, List<Annotation>> _fieldAnnotations = CollectionFactory.newMap();
    private Map<String, Object> _claimedFields = CollectionFactory.newMap();
    private Set<String> _addedFieldNames = CollectionFactory.newSet();
    private Set<CtBehavior> _addedMethods = CollectionFactory.newSet();
    private List<Annotation> _classAnnotations;
    private Map<CtMethod, List<Annotation>> _methodAnnotations = CollectionFactory.newMap();
    private Map<CtMethod, MethodSignature> _methodSignatures = CollectionFactory.newMap();
    private Map<String, String> _fieldReadTransforms;
    private Map<String, String> _fieldWriteTransforms;
    private Set<String> _removedFieldNames;
    private StringBuilder _constructor = new StringBuilder();
    private final List<ConstructorArg> _constructorArgs;
    private final ComponentModel _componentModel;
    private final String _resourcesFieldName;
    private final StringBuilder _description = new StringBuilder();
    private Formatter _formatter = new Formatter(this._description);
    private ClassLoader _loader;

    public InternalClassTransformationImpl(CtClass ctClass, ClassLoader loader, Log log, ComponentModel componentModel) {
        this._ctClass = ctClass;
        this._classPool = this._ctClass.getClassPool();
        this._loader = loader;
        this._parentTransformation = null;
        this._componentModel = componentModel;
        this._idAllocator = new IdAllocator();
        this._log = log;
        this.preloadMemberNames();
        this._constructorArgs = CollectionFactory.newList();
        this._constructor.append("{\n");
        this.addImplementedInterface(Component.class);
        this._resourcesFieldName = this.addInjectedFieldUncached(InternalComponentResources.class, "resources", null);
        MethodSignature sig = new MethodSignature(17, ComponentResources.class.getName(), "getComponentResources", null, null);
        this.addMethod(sig, "return " + this._resourcesFieldName + ";");
    }

    public InternalClassTransformationImpl(CtClass ctClass, InternalClassTransformation parentTransformation, ClassLoader loader, Log log, ComponentModel componentModel) {
        this._ctClass = ctClass;
        this._classPool = this._ctClass.getClassPool();
        this._loader = loader;
        this._log = log;
        this._parentTransformation = parentTransformation;
        this._componentModel = componentModel;
        this._resourcesFieldName = parentTransformation.getResourcesFieldName();
        this._idAllocator = parentTransformation.getIdAllocator();
        this.preloadMemberNames();
        this.verifyFields();
        this._constructorArgs = parentTransformation.getConstructorArgs();
        int count = this._constructorArgs.size();
        this._constructor.append("{ super(");
        for (int i = 1; i <= count; ++i) {
            if (i > 1) {
                this._constructor.append(", ");
            }
            this._constructor.append("$" + i);
        }
        this._constructor.append(");\n");
    }

    private void freeze() {
        this._frozen = true;
        this._fieldAnnotations = null;
        this._claimedFields = null;
        this._addedFieldNames = null;
        this._addedMethods = null;
        this._classAnnotations = null;
        this._methodAnnotations = null;
        this._methodSignatures = null;
        this._fieldReadTransforms = null;
        this._fieldWriteTransforms = null;
        this._removedFieldNames = null;
        this._constructor = null;
        this._formatter = null;
        this._loader = null;
        this._classPool = null;
    }

    @Override
    public String getResourcesFieldName() {
        return this._resourcesFieldName;
    }

    private void preloadMemberNames() {
        this.addMemberNames((CtMember[])this._ctClass.getDeclaredFields());
        this.addMemberNames((CtMember[])this._ctClass.getDeclaredMethods());
    }

    public void verifyFields() {
        List names = CollectionFactory.newList();
        for (CtField field : this._ctClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getName();
            if (this._addedFieldNames.contains(name) || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isPrivate(modifiers)) continue;
            names.add(name);
        }
        if (!names.isEmpty()) {
            Collections.sort(names);
            this._log.error((Object)ServicesMessages.nonPrivateFields(this.getClassName(), names));
        }
    }

    private void addMemberNames(CtMember[] members) {
        for (CtMember member : members) {
            this._idAllocator.allocateId(member.getName());
        }
    }

    @Override
    public <T extends Annotation> T getFieldAnnotation(String fieldName, Class<T> annotationClass) {
        this.failIfFrozen();
        List<Annotation> annotations = this.findFieldAnnotations(fieldName);
        return this.findAnnotationInList(annotationClass, annotations);
    }

    @Override
    public <T extends Annotation> T getMethodAnnotation(MethodSignature signature, Class<T> annotationClass) {
        this.failIfFrozen();
        CtMethod method = this.findMethod(signature);
        if (method == null) {
            throw new IllegalArgumentException(ServicesMessages.noDeclaredMethod(this._ctClass, signature));
        }
        List<Annotation> annotations = this.findMethodAnnotations(method);
        return this.findAnnotationInList(annotationClass, annotations);
    }

    private <T extends Annotation> T findAnnotationInList(Class<T> annotationClass, List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.findAnnotationInList(annotationClass, this.getClassAnnotations());
    }

    private List<Annotation> findFieldAnnotations(String fieldName) {
        List<Annotation> annotations = this._fieldAnnotations.get(fieldName);
        if (annotations == null) {
            annotations = this.findAnnotationsForField(fieldName);
            this._fieldAnnotations.put(fieldName, annotations);
        }
        return annotations;
    }

    private List<Annotation> findMethodAnnotations(CtMethod method) {
        List<Annotation> annotations = this._methodAnnotations.get(method);
        if (annotations == null) {
            annotations = this.extractAnnotations((CtMember)method);
            this._methodAnnotations.put(method, annotations);
        }
        return annotations;
    }

    private List<Annotation> findAnnotationsForField(String fieldName) {
        CtField field = this.findDeclaredCtField(fieldName);
        return this.extractAnnotations((CtMember)field);
    }

    private List<Annotation> extractAnnotations(CtMember member) {
        try {
            List result = CollectionFactory.newList();
            this.addAnnotationsToList(result, member.getAnnotations());
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addAnnotationsToList(List<Annotation> list, Object[] annotations) {
        for (Object o : annotations) {
            Annotation a = (Annotation)o;
            list.add(a);
        }
    }

    private CtField findDeclaredCtField(String fieldName) {
        try {
            return this._ctClass.getDeclaredField(fieldName);
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ServicesMessages.missingDeclaredField(this._ctClass, fieldName), ex);
        }
    }

    @Override
    public String newMemberName(String suggested) {
        this.failIfFrozen();
        String memberName = InternalUtils.createMemberName((String)Defense.notBlank((String)suggested, (String)"suggested"));
        return this._idAllocator.allocateId(memberName);
    }

    @Override
    public void addImplementedInterface(Class interfaceClass) {
        this.failIfFrozen();
        String interfaceName = interfaceClass.getName();
        try {
            CtClass ctInterface = this._classPool.get(interfaceName);
            if (this.classImplementsInterface(ctInterface)) {
                return;
            }
            this.implementDefaultMethodsForInterface(ctInterface);
            this._ctClass.addInterface(ctInterface);
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void implementDefaultMethodsForInterface(CtClass ctInterface) throws NotFoundException {
        if (ctInterface.getName().equals(Object.class.getName())) {
            return;
        }
        for (CtMethod ctMethod : ctInterface.getDeclaredMethods()) {
            this.addDefaultImplementation(ctMethod);
        }
        for (CtMethod ctMethod : ctInterface.getInterfaces()) {
            this.implementDefaultMethodsForInterface((CtClass)ctMethod);
        }
    }

    private void addDefaultImplementation(CtMethod method) throws NotFoundException {
        if (!Modifier.isAbstract(method.getModifiers())) {
            return;
        }
        try {
            CtMethod newMethod = CtNewMethod.copy((CtMethod)method, (CtClass)this._ctClass, null);
            newMethod.setModifiers(1);
            newMethod.setBody(null);
            this._ctClass.addMethod(newMethod);
            MethodSignature sig = this.getMethodSignature(newMethod);
            this.addMethodToDescription("add default", sig, "<default>");
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException(ServicesMessages.errorAddingMethod(this._ctClass, method.getName(), ex), ex);
        }
    }

    private boolean classImplementsInterface(CtClass ctInterface) throws NotFoundException {
        for (CtClass current = this._ctClass; current != null; current = current.getSuperclass()) {
            for (CtClass anInterface : current.getInterfaces()) {
                if (anInterface != ctInterface) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void claimField(String fieldName, Object tag) {
        Defense.notBlank((String)fieldName, (String)"fieldName");
        Defense.notNull((Object)tag, (String)"tag");
        this.failIfFrozen();
        Object existing = this._claimedFields.get(fieldName);
        if (existing != null) {
            String message = ServicesMessages.fieldAlreadyClaimed(fieldName, this._ctClass, existing, tag);
            throw new RuntimeException(message);
        }
        this._claimedFields.put(fieldName, tag);
    }

    @Override
    public void addMethod(MethodSignature signature, String methodBody) {
        this.failIfFrozen();
        CtClass returnType = this.findCtClass(signature.getReturnType());
        CtClass[] parameters = this.buildCtClassList(signature.getParameterTypes());
        CtClass[] exceptions = this.buildCtClassList(signature.getExceptionTypes());
        String action = "add";
        try {
            CtMethod existing = this._ctClass.getDeclaredMethod(signature.getMethodName(), parameters);
            if (existing != null) {
                action = "replace";
                this._ctClass.removeMethod(existing);
            }
        }
        catch (NotFoundException ex) {
            // empty catch block
        }
        try {
            CtMethod method = new CtMethod(returnType, signature.getMethodName(), parameters, this._ctClass);
            method.setModifiers(signature.getModifiers());
            method.setBody(methodBody);
            method.setExceptionTypes(exceptions);
            this._ctClass.addMethod(method);
            this._addedMethods.add((CtBehavior)method);
        }
        catch (CannotCompileException ex) {
            throw new MethodCompileException(ServicesMessages.methodCompileError(signature, methodBody, ex), methodBody, ex);
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
        this.addMethodToDescription(action, signature, methodBody);
    }

    private CtClass[] buildCtClassList(String[] typeNames) {
        CtClass[] result = new CtClass[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            result[i] = this.findCtClass(typeNames[i]);
        }
        return result;
    }

    private CtClass findCtClass(String type) {
        try {
            return this._classPool.get(type);
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void extendMethod(MethodSignature methodSignature, String methodBody) {
        this.failIfFrozen();
        CtMethod method = this.findMethod(methodSignature);
        try {
            method.insertAfter(methodBody);
        }
        catch (CannotCompileException ex) {
            throw new MethodCompileException(ServicesMessages.methodCompileError(methodSignature, methodBody, ex), methodBody, ex);
        }
        this.addMethodToDescription("extend", methodSignature, methodBody);
        this._addedMethods.add((CtBehavior)method);
    }

    private void addMethodToDescription(String operation, MethodSignature methodSignature, String methodBody) {
        this._formatter.format("%s method: %s %s %s(", operation, Modifier.toString(methodSignature.getModifiers()), methodSignature.getReturnType(), methodSignature.getMethodName());
        String[] parameterTypes = methodSignature.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                this._description.append(", ");
            }
            this._formatter.format("%s $%d", parameterTypes[i], i + 1);
        }
        this._description.append(")");
        String[] exceptionTypes = methodSignature.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            if (i == 0) {
                this._description.append("\n  throws ");
            } else {
                this._description.append(", ");
            }
            this._description.append(exceptionTypes[i]);
        }
        this._formatter.format("\n%s\n\n", methodBody);
    }

    private CtMethod findMethod(MethodSignature methodSignature) {
        CtMethod method = this.findDeclaredMethod(methodSignature);
        if (method != null) {
            return method;
        }
        CtMethod result = this.addOverrideOfSuperclassMethod(methodSignature);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException(ServicesMessages.noDeclaredMethod(this._ctClass, methodSignature));
    }

    private CtMethod findDeclaredMethod(MethodSignature methodSignature) {
        for (CtMethod method : this._ctClass.getDeclaredMethods()) {
            if (!this.match(method, methodSignature)) continue;
            return method;
        }
        return null;
    }

    private CtMethod addOverrideOfSuperclassMethod(MethodSignature methodSignature) {
        try {
            for (CtClass current = this._ctClass; current != null; current = current.getSuperclass()) {
                for (CtMethod method : current.getDeclaredMethods()) {
                    if (!this.match(method, methodSignature)) continue;
                    CtMethod newMethod = CtNewMethod.delegator((CtMethod)method, (CtClass)this._ctClass);
                    this._ctClass.addMethod(newMethod);
                    return newMethod;
                }
            }
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    private boolean match(CtMethod method, MethodSignature sig) {
        CtClass[] paramTypes;
        if (!sig.getMethodName().equals(method.getName())) {
            return false;
        }
        try {
            paramTypes = method.getParameterTypes();
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
        String[] sigTypes = sig.getParameterTypes();
        int count = sigTypes.length;
        if (paramTypes.length != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            String paramType = paramTypes[i].getName();
            if (paramType.equals(sigTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> findFieldsWithAnnotation(final Class<? extends Annotation> annotationClass) {
        FieldFilter filter = new FieldFilter(){

            public boolean accept(String fieldName, String fieldType) {
                return InternalClassTransformationImpl.this.getFieldAnnotation(fieldName, annotationClass) != null;
            }
        };
        return this.findFields(filter);
    }

    @Override
    public List<String> findFields(FieldFilter filter) {
        this.failIfFrozen();
        List result = CollectionFactory.newList();
        try {
            for (CtField field : this._ctClass.getDeclaredFields()) {
                String fieldName;
                if (!this.isInstanceField(field) || this._claimedFields.containsKey(fieldName = field.getName()) || !filter.accept(fieldName, field.getType().getName())) continue;
                result.add(fieldName);
            }
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> findFieldsOfType(final String type) {
        FieldFilter filter = new FieldFilter(){

            public boolean accept(String fieldName, String fieldType) {
                return type.equals(fieldType);
            }
        };
        return this.findFields(filter);
    }

    @Override
    public List<MethodSignature> findMethodsWithAnnotation(Class<? extends Annotation> annotationClass) {
        this.failIfFrozen();
        List result = CollectionFactory.newList();
        for (CtMethod method : this._ctClass.getDeclaredMethods()) {
            List<Annotation> annotations = this.findMethodAnnotations(method);
            if (this.findAnnotationInList(annotationClass, annotations) == null) continue;
            MethodSignature sig = this.getMethodSignature(method);
            result.add(sig);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<MethodSignature> findMethods(MethodFilter filter) {
        Defense.notNull((Object)filter, (String)"filter");
        List result = CollectionFactory.newList();
        for (CtMethod method : this._ctClass.getDeclaredMethods()) {
            MethodSignature sig = this.getMethodSignature(method);
            if (!filter.accept(sig)) continue;
            result.add(sig);
        }
        Collections.sort(result);
        return result;
    }

    private MethodSignature getMethodSignature(CtMethod method) {
        MethodSignature result = this._methodSignatures.get(method);
        if (result == null) {
            try {
                String type = method.getReturnType().getName();
                String[] parameters = this.toTypeNames(method.getParameterTypes());
                String[] exceptions = this.toTypeNames(method.getExceptionTypes());
                result = new MethodSignature(method.getModifiers(), type, method.getName(), parameters, exceptions);
                this._methodSignatures.put(method, result);
            }
            catch (NotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    private String[] toTypeNames(CtClass[] types) {
        String[] result = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i].getName();
        }
        return result;
    }

    @Override
    public List<String> findUnclaimedFields() {
        this.failIfFrozen();
        List names = CollectionFactory.newList();
        Set skipped = CollectionFactory.newSet();
        skipped.addAll(this._claimedFields.keySet());
        skipped.addAll(this._addedFieldNames);
        if (this._removedFieldNames != null) {
            skipped.addAll(this._removedFieldNames);
        }
        for (CtField field : this._ctClass.getDeclaredFields()) {
            String name;
            if (!this.isInstanceField(field) || skipped.contains(name = field.getName())) continue;
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    private boolean isInstanceField(CtField field) {
        int modifiers = field.getModifiers();
        return Modifier.isPrivate(modifiers) && !Modifier.isStatic(modifiers);
    }

    @Override
    public String getFieldType(String fieldName) {
        this.failIfFrozen();
        CtClass type = this.getFieldCtType(fieldName);
        return type.getName();
    }

    private CtClass getFieldCtType(String fieldName) {
        try {
            CtField field = this._ctClass.getDeclaredField(fieldName);
            return field.getType();
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String addField(int modifiers, String type, String suggestedName) {
        this.failIfFrozen();
        String fieldName = this.newMemberName(suggestedName);
        try {
            CtClass ctType = this.convertNameToCtType(type);
            CtField field = new CtField(ctType, fieldName, this._ctClass);
            field.setModifiers(modifiers);
            this._ctClass.addField(field);
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException(ex);
        }
        this._formatter.format("add field: %s %s %s;\n\n", Modifier.toString(modifiers), type, fieldName);
        this._addedFieldNames.add(fieldName);
        return fieldName;
    }

    @Override
    public String addInjectedField(Class type, String suggestedName, Object value) {
        Defense.notNull((Object)type, (String)"type");
        this.failIfFrozen();
        MultiKey key = new MultiKey(type, value);
        String fieldName = this.searchForPreviousInjection(key);
        if (fieldName != null) {
            return fieldName;
        }
        fieldName = this.addInjectedFieldUncached(type, suggestedName, value);
        this._injectionCache.put(key, fieldName);
        return fieldName;
    }

    private String addInjectedFieldUncached(Class type, String suggestedName, Object value) {
        CtClass ctType;
        try {
            ctType = this._classPool.get(type.getName());
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
        String fieldName = this.addField(20, type.getName(), suggestedName);
        this.addInjectToConstructor(fieldName, ctType, value);
        return fieldName;
    }

    @Override
    public String searchForPreviousInjection(MultiKey key) {
        String result = this._injectionCache.get(key);
        if (result != null) {
            return result;
        }
        if (this._parentTransformation != null) {
            return this._parentTransformation.searchForPreviousInjection(key);
        }
        return null;
    }

    private void addInjectToConstructor(String fieldName, CtClass fieldType, Object value) {
        this._constructorArgs.add(new ConstructorArg(fieldType, value));
        this._constructor.append(String.format("  %s = $%d;\n", fieldName, this._constructorArgs.size()));
    }

    @Override
    public void injectField(String fieldName, Object value) {
        Defense.notNull((Object)fieldName, (String)"fieldName");
        this.failIfFrozen();
        CtClass type = this.getFieldCtType(fieldName);
        this.addInjectToConstructor(fieldName, type, value);
        this.makeReadOnly(fieldName);
    }

    private CtClass convertNameToCtType(String type) throws NotFoundException {
        return this._classPool.get(type);
    }

    @Override
    public void finish() {
        this.failIfFrozen();
        this.performFieldTransformations();
        this.addConstructor();
        this.verifyFields();
        this.freeze();
    }

    private void addConstructor() {
        String initializer = this._idAllocator.allocateId("initializer");
        try {
            CtConstructor defaultConstructor = this._ctClass.getConstructor("()V");
            CtMethod initializerMethod = defaultConstructor.toMethod(initializer, this._ctClass);
            this._ctClass.addMethod(initializerMethod);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this._formatter.format("convert default constructor: %s();\n\n", initializer);
        int count = this._constructorArgs.size();
        CtClass[] types = new CtClass[count];
        for (int i = 0; i < count; ++i) {
            ConstructorArg arg = this._constructorArgs.get(i);
            types[i] = arg.getType();
        }
        this._constructor.append("  ");
        this._constructor.append(initializer);
        this._constructor.append("();\n\n}");
        String constructorBody = this._constructor.toString();
        try {
            CtConstructor cons = CtNewConstructor.make((CtClass[])types, null, (String)constructorBody, (CtClass)this._ctClass);
            this._ctClass.addConstructor(cons);
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException(ex);
        }
        this._formatter.format("add constructor: %s(", this._ctClass.getName());
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this._description.append(", ");
            }
            this._formatter.format("%s $%d", types[i].getName(), i + 1);
        }
        this._formatter.format(")\n%s\n\n", constructorBody);
    }

    @Override
    public Instantiator createInstantiator(Class componentClass) {
        String className = this._ctClass.getName();
        if (!className.equals(componentClass.getName())) {
            throw new IllegalArgumentException(ServicesMessages.incorrectClassForInstantiator(className, componentClass));
        }
        Object[] parameters = new Object[this._constructorArgs.size()];
        for (int i = 1; i < this._constructorArgs.size(); ++i) {
            parameters[i] = this._constructorArgs.get(i).getValue();
        }
        return new ReflectiveInstantiator(this._componentModel, componentClass, parameters);
    }

    private void failIfFrozen() {
        if (this._frozen) {
            throw new IllegalStateException("The ClassTransformation instance (for " + this._ctClass.getName() + ") has completed all transformations and may not be further modified.");
        }
    }

    private void failIfNotFrozen() {
        if (!this._frozen) {
            throw new IllegalStateException("The ClassTransformation instance (for " + this._ctClass.getName() + ") has not yet completed all transformations.");
        }
    }

    @Override
    public IdAllocator getIdAllocator() {
        this.failIfNotFrozen();
        return this._idAllocator;
    }

    @Override
    public List<ConstructorArg> getConstructorArgs() {
        this.failIfNotFrozen();
        return CollectionFactory.newList(this._constructorArgs);
    }

    public List<Annotation> getClassAnnotations() {
        this.failIfFrozen();
        if (this._classAnnotations == null) {
            this.assembleClassAnnotations();
        }
        return this._classAnnotations;
    }

    private void assembleClassAnnotations() {
        this._classAnnotations = CollectionFactory.newList();
        try {
            for (CtClass current = this._ctClass; current != null; current = current.getSuperclass()) {
                this.addAnnotationsToList(this._classAnnotations, current.getAnnotations());
            }
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("InternalClassTransformation[\n");
        try {
            Formatter formatter = new Formatter(builder);
            formatter.format("%s %s extends %s", Modifier.toString(this._ctClass.getModifiers()), this._ctClass.getName(), this._ctClass.getSuperclass().getName());
            CtClass[] interfaces = this._ctClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (i == 0) {
                    builder.append("\n  implements ");
                } else {
                    builder.append(", ");
                }
                builder.append(interfaces[i].getName());
            }
            formatter.format("\n\n%s", this._description.toString());
        }
        catch (NotFoundException ex) {
            builder.append((Object)ex);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void makeReadOnly(String fieldName) {
        String methodName = this.newMemberName("write_" + InternalUtils.stripMemberPrefix((String)fieldName));
        String fieldType = this.getFieldType(fieldName);
        MethodSignature sig = new MethodSignature(2, "void", methodName, new String[]{fieldType}, null);
        String message = ServicesMessages.readOnlyField(this._ctClass.getName(), fieldName);
        String body = String.format("throw new java.lang.RuntimeException(\"%s\");", message);
        this.addMethod(sig, body);
        this.replaceWriteAccess(fieldName, methodName);
    }

    @Override
    public void removeField(String fieldName) {
        this._formatter.format("remove field %s;\n\n", fieldName);
        if (this._removedFieldNames == null) {
            this._removedFieldNames = CollectionFactory.newSet();
        }
        this._removedFieldNames.add(fieldName);
    }

    @Override
    public void replaceReadAccess(String fieldName, String methodName) {
        String body = String.format("$_ = %s();", methodName);
        if (this._fieldReadTransforms == null) {
            this._fieldReadTransforms = CollectionFactory.newMap();
        }
        this._fieldReadTransforms.put(fieldName, body);
        this._formatter.format("replace read %s: %s();\n\n", fieldName, methodName);
    }

    @Override
    public void replaceWriteAccess(String fieldName, String methodName) {
        String body = String.format("%s($1);", methodName);
        if (this._fieldWriteTransforms == null) {
            this._fieldWriteTransforms = CollectionFactory.newMap();
        }
        this._fieldWriteTransforms.put(fieldName, body);
        this._formatter.format("replace write %s: %s();\n\n", fieldName, methodName);
    }

    private void performFieldTransformations() {
        if (this._fieldReadTransforms != null || this._fieldWriteTransforms != null) {
            this.replaceFieldAccess();
        }
        if (this._removedFieldNames != null) {
            for (String fieldName : this._removedFieldNames) {
                try {
                    CtField field = this._ctClass.getDeclaredField(fieldName);
                    this._ctClass.removeField(field);
                }
                catch (NotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private void replaceFieldAccess() {
        if (this._fieldReadTransforms == null) {
            this._fieldReadTransforms = CollectionFactory.newMap();
        }
        if (this._fieldWriteTransforms == null) {
            this._fieldWriteTransforms = CollectionFactory.newMap();
        }
        ExprEditor editor = new ExprEditor(){

            public void edit(FieldAccess access) throws CannotCompileException {
                if (InternalClassTransformationImpl.this._addedMethods.contains(access.where())) {
                    return;
                }
                Map transformMap = access.isReader() ? InternalClassTransformationImpl.this._fieldReadTransforms : InternalClassTransformationImpl.this._fieldWriteTransforms;
                String body = (String)transformMap.get(access.getFieldName());
                if (body != null) {
                    access.replace(body);
                }
            }
        };
        try {
            this._ctClass.instrument(editor);
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Class toClass(String type) {
        this.failIfFrozen();
        String finalType = TransformUtils.getWrapperTypeName(type);
        try {
            return Class.forName(finalType, true, this._loader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getClassName() {
        return this._ctClass.getName();
    }

    @Override
    public Log getLog() {
        return this._log;
    }

    @Override
    public void addToConstructor(String statement) {
        Defense.notNull((Object)statement, (String)"statement");
        this.failIfFrozen();
        this._constructor.append(statement);
    }
}

