/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.Link;
import org.apache.tapestry.internal.services.ComponentInvocation;
import org.apache.tapestry.internal.services.OpaqueConstantTarget;
import org.apache.tapestry.internal.services.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkImpl
implements Link {
    private final URLEncoder _encoder;
    private final String _contextPath;
    private final ComponentInvocation _invocation;
    private final boolean _forForm;

    public LinkImpl(URLEncoder encoder, String contextPath, String targetPath) {
        this(encoder, contextPath, targetPath, false);
    }

    public LinkImpl(URLEncoder encoder, String contextPath, String targetPath, boolean forForm) {
        this(encoder, contextPath, new ComponentInvocation(new OpaqueConstantTarget(targetPath), new Object[0]), forForm);
    }

    public LinkImpl(URLEncoder encoder, String contextPath, ComponentInvocation invocation, boolean forForm) {
        this._contextPath = contextPath;
        this._encoder = encoder;
        this._invocation = invocation;
        this._forForm = forForm;
    }

    @Override
    public void addParameter(String parameterName, String value) {
        this._invocation.addParameter(parameterName, value);
    }

    @Override
    public List<String> getParameterNames() {
        return this._invocation.getParameterNames();
    }

    @Override
    public String getParameterValue(String name) {
        return this._invocation.getParameterValue(name);
    }

    @Override
    public String toURI() {
        return this._encoder.encodeURL(this.buildURI());
    }

    private String buildURI() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._contextPath);
        builder.append("/");
        builder.append(this._invocation.buildURI(this._forForm));
        return builder.toString();
    }

    @Override
    public String toRedirectURI() {
        return this._encoder.encodeRedirectURL(this.buildURI());
    }

    public ComponentInvocation getInvocation() {
        return this._invocation;
    }

    public String toString() {
        return this.toURI();
    }
}

