/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.internal.services.LocalizationSetter;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ThreadLocale;
import org.apache.tapestry.services.PersistentLocale;

public class LocalizationSetterImpl
implements LocalizationSetter {
    private final ThreadLocale _threadLocale;
    private final Locale _defaultLocale;
    private final Set<String> _acceptedLocaleNames;
    private final Map<String, Locale> _localeCache = CollectionFactory.newThreadSafeMap();
    private PersistentLocale _persistentLocale;

    public LocalizationSetterImpl(PersistentLocale persistentLocale, ThreadLocale threadLocale, String acceptedLocaleNames) {
        this._persistentLocale = persistentLocale;
        this._threadLocale = threadLocale;
        Object[] names = acceptedLocaleNames.split(",");
        this._defaultLocale = this.toLocale(names[0]);
        this._acceptedLocaleNames = CollectionFactory.newSet((Object[])names);
    }

    Locale toLocale(String localeName) {
        Locale result = this._localeCache.get(localeName);
        if (result == null) {
            result = this.constructLocale(localeName);
            this._localeCache.put(localeName, result);
        }
        return result;
    }

    private Locale constructLocale(String name) {
        String[] terms = name.split("_");
        switch (terms.length) {
            case 1: {
                return new Locale(terms[0], "");
            }
            case 2: {
                return new Locale(terms[0], terms[1]);
            }
            case 3: {
                return new Locale(terms[0], terms[1], terms[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setThreadLocale(Locale desiredLocale) {
        if (this._persistentLocale.get() != null) {
            desiredLocale = this._persistentLocale.get();
        }
        Locale locale = this.findClosestAcceptedLocale(desiredLocale);
        this._threadLocale.setLocale(locale);
    }

    private Locale findClosestAcceptedLocale(Locale desiredLocale) {
        String localeName = desiredLocale.toString();
        do {
            if (!this._acceptedLocaleNames.contains(localeName)) continue;
            return this.toLocale(localeName);
        } while ((localeName = LocalizationSetterImpl.stripTerm(localeName)).length() != 0);
        return this._defaultLocale;
    }

    static String stripTerm(String localeName) {
        int scorex = localeName.lastIndexOf(95);
        return scorex < 0 ? "" : localeName.substring(0, scorex);
    }
}

