/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.annotations.Mixin;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassResolver;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.TransformConstants;

public class MixinWorker
implements ComponentClassTransformWorker {
    private final ComponentClassResolver _resolver;

    public MixinWorker(ComponentClassResolver resolver) {
        this._resolver = resolver;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        List<String> fields = transformation.findFieldsWithAnnotation(Mixin.class);
        for (String fieldName : fields) {
            Mixin annotation = transformation.getFieldAnnotation(fieldName, Mixin.class);
            String mixinType = annotation.value();
            String fieldType = transformation.getFieldType(fieldName);
            String mixinClassName = InternalUtils.isBlank((String)mixinType) ? fieldType : this._resolver.resolveMixinTypeToClassName(mixinType);
            model.addMixinClassName(mixinClassName);
            transformation.makeReadOnly(fieldName);
            String body = String.format("%s = (%s) %s.getMixinByClassName(\"%s\");", fieldName, fieldType, transformation.getResourcesFieldName(), mixinClassName);
            transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, body);
            transformation.claimField(fieldName, annotation);
        }
    }
}

