/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.Binding;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.internal.parser.AttributeToken;
import org.apache.tapestry.internal.parser.CommentToken;
import org.apache.tapestry.internal.parser.ExpansionToken;
import org.apache.tapestry.internal.parser.StartElementToken;
import org.apache.tapestry.internal.parser.TextToken;
import org.apache.tapestry.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry.internal.services.Instantiator;
import org.apache.tapestry.internal.services.PageElementFactory;
import org.apache.tapestry.internal.structure.AttributePageElement;
import org.apache.tapestry.internal.structure.CommentPageElement;
import org.apache.tapestry.internal.structure.ComponentPageElement;
import org.apache.tapestry.internal.structure.ComponentPageElementImpl;
import org.apache.tapestry.internal.structure.ExpansionPageElement;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.internal.structure.PageElement;
import org.apache.tapestry.internal.structure.StartElementPageElement;
import org.apache.tapestry.internal.structure.TextPageElement;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.TapestryException;
import org.apache.tapestry.ioc.services.TypeCoercer;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.runtime.RenderQueue;
import org.apache.tapestry.services.BindingSource;
import org.apache.tapestry.services.ComponentClassResolver;
import org.apache.tapestry.services.ComponentMessagesSource;

public class PageElementFactoryImpl
implements PageElementFactory {
    private final ComponentInstantiatorSource _componentInstantiatorSource;
    private final ComponentClassResolver _componentClassResolver;
    private final TypeCoercer _typeCoercer;
    private final BindingSource _bindingSource;
    private final ComponentMessagesSource _messagesSource;
    private final PageElement _endElement = new PageElement(){

        public void render(MarkupWriter writer, RenderQueue queue) {
            writer.end();
        }

        public String toString() {
            return "End";
        }
    };

    public PageElementFactoryImpl(ComponentInstantiatorSource componentInstantiatorSource, ComponentClassResolver resolver, TypeCoercer typeCoercer, BindingSource bindingSource, ComponentMessagesSource messagesSource) {
        this._componentInstantiatorSource = componentInstantiatorSource;
        this._componentClassResolver = resolver;
        this._typeCoercer = typeCoercer;
        this._bindingSource = bindingSource;
        this._messagesSource = messagesSource;
    }

    public PageElement newStartElement(StartElementToken token) {
        return new StartElementPageElement(token.getName());
    }

    public PageElement newTextElement(TextToken token) {
        return new TextPageElement(token.getText());
    }

    public PageElement newEndElement() {
        return this._endElement;
    }

    public PageElement newAttributeElement(AttributeToken token) {
        return new AttributePageElement(token.getName(), token.getValue());
    }

    public PageElement newExpansionElement(ComponentResources componentResources, ExpansionToken token) {
        Binding binding = this._bindingSource.newBinding("expansion", componentResources, componentResources, "prop", token.getExpression(), token.getLocation());
        return new ExpansionPageElement(binding, this._typeCoercer);
    }

    public ComponentPageElement newComponentElement(Page page, ComponentPageElement container, String id, String componentType, String componentClassName, String elementName, Location location) {
        String finalClassName = componentClassName;
        if (InternalUtils.isNonBlank((String)componentType)) {
            try {
                finalClassName = this._componentClassResolver.resolveComponentTypeToClassName(componentType);
            }
            catch (IllegalArgumentException ex) {
                throw new TapestryException(ex.getMessage(), location, (Throwable)ex);
            }
        }
        Instantiator instantiator = this._componentInstantiatorSource.findInstantiator(finalClassName);
        ComponentPageElementImpl result = new ComponentPageElementImpl(page, container, id, elementName, instantiator, this._typeCoercer, this._messagesSource, location);
        page.addLifecycleListener(result);
        container.addEmbeddedElement(result);
        this.addMixins(result, instantiator);
        return result;
    }

    public ComponentPageElement newRootComponentElement(Page page, String componentType) {
        Instantiator instantiator = this._componentInstantiatorSource.findInstantiator(componentType);
        ComponentPageElementImpl result = new ComponentPageElementImpl(page, instantiator, this._typeCoercer, this._messagesSource);
        this.addMixins(result, instantiator);
        page.addLifecycleListener(result);
        return result;
    }

    private void addMixins(ComponentPageElement component, Instantiator instantiator) {
        ComponentModel model = instantiator.getModel();
        for (String mixinClassName : model.getMixinClassNames()) {
            this.addMixinByClassName(component, mixinClassName);
        }
    }

    public PageElement newRenderBodyElement(final ComponentPageElement component) {
        return new PageElement(){

            public void render(MarkupWriter writer, RenderQueue queue) {
                component.enqueueBeforeRenderBody(queue);
            }

            public String toString() {
                return String.format("RenderBody[%s]", component.getId());
            }
        };
    }

    public void addMixinByTypeName(ComponentPageElement component, String mixinType) {
        String mixinClassName = this._componentClassResolver.resolveMixinTypeToClassName(mixinType);
        this.addMixinByClassName(component, mixinClassName);
    }

    public void addMixinByClassName(ComponentPageElement component, String mixinClassName) {
        Instantiator mixinInstantiator = this._componentInstantiatorSource.findInstantiator(mixinClassName);
        component.addMixin(mixinInstantiator);
    }

    public PageElement newCommentElement(CommentToken token) {
        return new CommentPageElement(token.getComment());
    }
}

