/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.events.InvalidationListener;
import org.apache.tapestry.internal.services.PageLoader;
import org.apache.tapestry.internal.services.PageLocator;
import org.apache.tapestry.internal.services.PagePool;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ThreadLocale;

public class PagePoolImpl
implements PagePool,
InvalidationListener {
    private final Log _log;
    private final PageLoader _pageLoader;
    private final ThreadLocale _threadLocale;
    private final Map<PageLocator, List<Page>> _pool = CollectionFactory.newMap();

    public PagePoolImpl(Log log, PageLoader pageLoader, ThreadLocale threadLocale) {
        this._log = log;
        this._pageLoader = pageLoader;
        this._threadLocale = threadLocale;
    }

    public synchronized Page checkout(String pageName) {
        Locale locale = this._threadLocale.getLocale();
        List<Page> pages = this._pool.get(new PageLocator(pageName, locale));
        if (pages == null || pages.isEmpty()) {
            return this._pageLoader.loadPage(pageName, locale);
        }
        return pages.remove(pages.size() - 1);
    }

    public synchronized void release(Page page) {
        boolean dirty = page.detached();
        if (dirty) {
            this._log.error((Object)ServicesMessages.pageIsDirty(page));
            return;
        }
        PageLocator locator = new PageLocator(page.getName(), page.getLocale());
        List pages = this._pool.get(locator);
        if (pages == null) {
            pages = CollectionFactory.newList();
            this._pool.put(locator, pages);
        }
        pages.add(page);
    }

    public synchronized void objectWasInvalidated() {
        this._pool.clear();
    }
}

