/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.Binding;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.internal.InternalComponentResources;
import org.apache.tapestry.internal.bindings.LiteralBinding;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.BindingSource;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.FieldFilter;
import org.apache.tapestry.services.MethodFilter;
import org.apache.tapestry.services.MethodSignature;
import org.apache.tapestry.services.TransformConstants;
import org.apache.tapestry.services.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterWorker
implements ComponentClassTransformWorker {
    private static final String BIND_METHOD_NAME = ParameterWorker.class.getName() + ".bind";
    private final BindingSource _bindingSource;

    public ParameterWorker(BindingSource bindingSource) {
        this._bindingSource = bindingSource;
    }

    @Override
    public void transform(final ClassTransformation transformation, MutableComponentModel model) {
        FieldFilter filter = new FieldFilter(){

            public boolean accept(String fieldName, String fieldType) {
                Parameter annotation = transformation.getFieldAnnotation(fieldName, Parameter.class);
                return annotation != null && annotation.principal();
            }
        };
        List<String> principleFieldNames = transformation.findFields(filter);
        this.convertFieldsIntoParameters(transformation, model, principleFieldNames);
        List<String> fieldNames = transformation.findFieldsWithAnnotation(Parameter.class);
        this.convertFieldsIntoParameters(transformation, model, fieldNames);
    }

    private void convertFieldsIntoParameters(ClassTransformation transformation, MutableComponentModel model, List<String> fieldNames) {
        for (String name : fieldNames) {
            this.convertFieldIntoParameter(name, transformation, model);
        }
    }

    private void convertFieldIntoParameter(String name, ClassTransformation transformation, MutableComponentModel model) {
        Parameter annotation = transformation.getFieldAnnotation(name, Parameter.class);
        String parameterName = this.getParameterName(name, annotation.name());
        model.addParameter(parameterName, annotation.required(), annotation.defaultPrefix());
        String type = transformation.getFieldType(name);
        boolean cache = annotation.cache();
        String cachedFieldName = transformation.addField(2, "boolean", name + "_cached");
        String resourcesFieldName = transformation.getResourcesFieldName();
        String invariantFieldName = this.addParameterSetup(name, annotation.value(), parameterName, cachedFieldName, cache, type, resourcesFieldName, transformation);
        this.addReaderMethod(name, cachedFieldName, invariantFieldName, cache, parameterName, type, resourcesFieldName, transformation);
        this.addWriterMethod(name, cachedFieldName, cache, parameterName, type, resourcesFieldName, transformation);
        transformation.claimField(name, annotation);
    }

    private String addParameterSetup(String fieldName, String defaultBinding, String parameterName, String cachedFieldName, boolean cache, String fieldType, String resourcesFieldName, ClassTransformation transformation) {
        String defaultFieldName = transformation.addField(2, fieldType, fieldName + "_default");
        String invariantFieldName = transformation.addField(2, "boolean", fieldName + "_invariant");
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        this.addDefaultBindingSetup(parameterName, defaultBinding, resourcesFieldName, transformation, builder);
        builder.addln("%s = %s.isInvariant(\"%s\");", new Object[]{invariantFieldName, resourcesFieldName, parameterName});
        builder.addln("%s = %s;", new Object[]{defaultFieldName, fieldName});
        builder.end();
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, builder.toString());
        if (cache) {
            builder.clear();
            builder.addln("if (! %s)", new Object[]{invariantFieldName});
            builder.begin();
            builder.addln("%s = %s;", new Object[]{fieldName, defaultFieldName});
            builder.addln("%s = false;", new Object[]{cachedFieldName});
            builder.end();
            transformation.extendMethod(TransformConstants.POST_RENDER_CLEANUP_SIGNATURE, builder.toString());
        }
        return invariantFieldName;
    }

    private void addDefaultBindingSetup(String parameterName, String defaultBinding, String resourcesFieldName, ClassTransformation transformation, BodyBuilder builder) {
        if (InternalUtils.isNonBlank((String)defaultBinding)) {
            builder.addln("if (! %s.isBound(\"%s\"))", new Object[]{resourcesFieldName, parameterName});
            String bindingFactoryFieldName = transformation.addInjectedField(BindingSource.class, "bindingSource", this._bindingSource);
            builder.addln("  %s.bindParameter(\"%s\", %s.newBinding(\"default %2$s\", %1$s, \"%s\"));", new Object[]{resourcesFieldName, parameterName, bindingFactoryFieldName, defaultBinding});
            return;
        }
        final String methodName = "default" + InternalUtils.capitalize((String)parameterName);
        MethodFilter filter = new MethodFilter(){

            public boolean accept(MethodSignature signature) {
                return signature.getParameterTypes().length == 0 && signature.getMethodName().equals(methodName);
            }
        };
        List<MethodSignature> signatures = transformation.findMethods(filter);
        if (signatures.isEmpty()) {
            return;
        }
        builder.addln("if (! %s.isBound(\"%s\"))", new Object[]{resourcesFieldName, parameterName});
        builder.addln("  %s(\"%s\", %s, %s());", new Object[]{BIND_METHOD_NAME, parameterName, resourcesFieldName, methodName});
    }

    private void addWriterMethod(String fieldName, String cachedFieldName, boolean cache, String parameterName, String fieldType, String resourcesFieldName, ClassTransformation transformation) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if (! %s.isLoaded())", new Object[]{resourcesFieldName});
        builder.begin();
        builder.addln("%s = $1;", new Object[]{fieldName});
        builder.addln("return;", new Object[0]);
        builder.end();
        builder.addln("if (%s.isBound(\"%s\"))", new Object[]{resourcesFieldName, parameterName});
        builder.addln("  %s.writeParameter(\"%s\", ($w)$1);", new Object[]{resourcesFieldName, parameterName});
        builder.addln("%s = $1;", new Object[]{fieldName});
        if (cache) {
            builder.addln("%s = %s.isRendering();", new Object[]{cachedFieldName, resourcesFieldName});
        }
        builder.end();
        String methodName = transformation.newMemberName("update_parameter_" + parameterName);
        MethodSignature signature = new MethodSignature(2, "void", methodName, new String[]{fieldType}, null);
        transformation.addMethod(signature, builder.toString());
        transformation.replaceWriteAccess(fieldName, methodName);
    }

    private void addReaderMethod(String fieldName, String cachedFieldName, String invariantFieldName, boolean cache, String parameterName, String fieldType, String resourcesFieldName, ClassTransformation transformation) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if (%s || ! %s.isLoaded() || ! %<s.isBound(\"%s\")) return %s;", new Object[]{cachedFieldName, resourcesFieldName, parameterName, fieldName});
        String cast = TransformUtils.getWrapperTypeName(fieldType);
        builder.addln("%s result = ($r) ((%s) %s.readParameter(\"%s\", $type));", new Object[]{fieldType, cast, resourcesFieldName, parameterName});
        builder.add("if (%s", new Object[]{invariantFieldName});
        if (cache) {
            builder.add(" || %s.isRendering()", new Object[]{resourcesFieldName});
        }
        builder.addln(")", new Object[0]);
        builder.begin();
        builder.addln("%s = result;", new Object[]{fieldName});
        builder.addln("%s = true;", new Object[]{cachedFieldName});
        builder.end();
        builder.addln("return result;", new Object[0]);
        builder.end();
        String methodName = transformation.newMemberName("read_parameter_" + parameterName);
        MethodSignature signature = new MethodSignature(2, fieldType, methodName, null, null);
        transformation.addMethod(signature, builder.toString());
        transformation.replaceReadAccess(fieldName, methodName);
    }

    private String getParameterName(String fieldName, String annotatedName) {
        if (InternalUtils.isNonBlank((String)annotatedName)) {
            return annotatedName;
        }
        return InternalUtils.stripMemberPrefix((String)fieldName);
    }

    public static void bind(String parameterName, InternalComponentResources resources, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Binding) {
            Binding binding = (Binding)value;
            resources.bindParameter(parameterName, binding);
            return;
        }
        resources.bindParameter(parameterName, new LiteralBinding("default " + parameterName, value, null));
    }
}

