/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.MethodSignature;
import org.apache.tapestry.services.TransformConstants;
import org.apache.tapestry.services.TransformUtils;

public class PersistWorker
implements ComponentClassTransformWorker {
    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        for (String name : transformation.findFieldsWithAnnotation(Persist.class)) {
            this.makeFieldPersistent(name, transformation, model);
        }
    }

    private void makeFieldPersistent(String fieldName, ClassTransformation transformation, MutableComponentModel model) {
        String fieldType = transformation.getFieldType(fieldName);
        Persist annotation = transformation.getFieldAnnotation(fieldName, Persist.class);
        String logicalFieldName = model.setFieldPersistenceStrategy(fieldName, annotation.value());
        String defaultFieldName = transformation.addField(2, fieldType, fieldName + "_default");
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, String.format("%s = %s;", defaultFieldName, fieldName));
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_DETACH_SIGNATURE, String.format("%s = %s;", fieldName, defaultFieldName));
        String resourcesFieldName = transformation.getResourcesFieldName();
        String writeMethodName = transformation.newMemberName("_write_" + InternalUtils.stripMemberPrefix((String)fieldName));
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("%s.persistFieldChange(\"%s\", ($w) $1);", new Object[]{resourcesFieldName, logicalFieldName});
        builder.addln("%s = $1;", new Object[]{fieldName});
        builder.end();
        transformation.addMethod(new MethodSignature(2, "void", writeMethodName, new String[]{fieldType}, null), builder.toString());
        transformation.replaceWriteAccess(fieldName, writeMethodName);
        builder.clear();
        builder.begin();
        builder.addln("if (%s.hasFieldChange(\"%s\"))", new Object[]{resourcesFieldName, logicalFieldName});
        String wrapperType = TransformUtils.getWrapperTypeName(fieldType);
        builder.add("  %s = ((%s) %s.getFieldChange(\"%s\"))", new Object[]{fieldName, wrapperType, resourcesFieldName, logicalFieldName});
        String unwrapMethodName = TransformUtils.getUnwrapperMethodName(fieldType);
        if (unwrapMethodName == null) {
            builder.addln(";", new Object[0]);
        } else {
            builder.addln(".%s();", new Object[]{unwrapMethodName});
        }
        builder.end();
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_ATTACH_SIGNATURE, builder.toString());
        transformation.claimField(fieldName, annotation);
    }
}

