/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.runtime.RenderCommand;
import org.apache.tapestry.runtime.RenderQueue;

public class RenderQueueImpl
implements RenderQueue {
    private final LinkedList<RenderCommand> _queue = CollectionFactory.newLinkedList();
    private final Log _log;

    public RenderQueueImpl(Log log) {
        this._log = log;
    }

    public void push(RenderCommand command) {
        this._queue.addFirst(command);
    }

    public void run(MarkupWriter writer) {
        RenderCommand command = null;
        try {
            while (!this._queue.isEmpty()) {
                command = this._queue.removeFirst();
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)String.format("Executing: %s", command));
                }
                command.render(writer, this);
            }
        }
        catch (RuntimeException ex) {
            this._log.error((Object)ServicesMessages.renderQueueError(command, ex), (Throwable)ex);
            throw ex;
        }
    }
}

