/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Map;
import org.apache.tapestry.internal.services.PagePool;
import org.apache.tapestry.internal.services.RequestPageCache;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ThreadCleanupListener;
import org.apache.tapestry.services.ComponentClassResolver;

public class RequestPageCacheImpl
implements RequestPageCache,
ThreadCleanupListener {
    private final ComponentClassResolver _resolver;
    private final PagePool _pagePool;
    private final Map<String, Page> _cache = CollectionFactory.newMap();

    public RequestPageCacheImpl(ComponentClassResolver resolver, PagePool pagePool) {
        this._resolver = resolver;
        this._pagePool = pagePool;
    }

    public Page get(String pageName) {
        String className = this._resolver.resolvePageNameToClassName(pageName);
        if (className == null) {
            throw new IllegalArgumentException(ServicesMessages.pageDoesNotExist(pageName));
        }
        return this.getByClassName(className);
    }

    public Page getByClassName(String className) {
        Page page = this._cache.get(className);
        if (page == null) {
            page = this._pagePool.checkout(className);
            page.attached();
            this._cache.put(className, page);
        }
        return page;
    }

    public void threadDidCleanup() {
        for (Page p : this._cache.values()) {
            this._pagePool.release(p);
        }
    }
}

