/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.tapestry.internal.TapestryUtils;
import org.apache.tapestry.services.ResourceDigestGenerator;

public class ResourceDigestGeneratorImpl
implements ResourceDigestGenerator {
    private static final int BUFFER_SIZE = 5000;

    public String generateDigest(URL url) {
        String string;
        BufferedInputStream stream = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            stream = new BufferedInputStream(url.openStream());
            this.digestStream(digest, stream);
            ((InputStream)stream).close();
            stream = null;
            byte[] bytes = digest.digest();
            char[] encoded = Hex.encodeHex((byte[])bytes);
            string = new String(encoded);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                TapestryUtils.close(stream);
                throw throwable;
            }
        }
        TapestryUtils.close(stream);
        return string;
    }

    private void digestStream(MessageDigest digest, InputStream stream) throws IOException {
        byte[] buffer = new byte[5000];
        int length;
        while ((length = stream.read(buffer)) >= 0) {
            digest.update(buffer, 0, length);
        }
        return;
    }

    public boolean requiresDigest(String path) {
        return path.endsWith(".class");
    }
}

