/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tapestry.internal.TapestryUtils;
import org.apache.tapestry.internal.services.ResourceStreamer;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.services.Response;

public class ResourceStreamerImpl
implements ResourceStreamer {
    private final Response _response;
    private final int _bufferSize = 1000;
    static final long EXPIRE_DELTA = 31536000000L;

    public ResourceStreamerImpl(Response response) {
        this._response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamResource(Resource resource) throws IOException {
        URL url = resource.toURL();
        URLConnection connection = url.openConnection();
        int contentLength = connection.getContentLength();
        if (contentLength >= 0) {
            this._response.setContentLength(contentLength);
        }
        long lastModified = connection.getLastModified();
        this._response.setDateHeader("Last-Modified", lastModified);
        this._response.setDateHeader("Expires", lastModified + 31536000000L);
        BufferedInputStream is = null;
        try {
            int length;
            connection.connect();
            is = new BufferedInputStream(connection.getInputStream());
            OutputStream os = this._response.getOutputStream();
            byte[] buffer = new byte[1000];
            while ((length = ((InputStream)is).read(buffer)) >= 0) {
                os.write(buffer, 0, length);
            }
            ((InputStream)is).close();
            is = null;
            os.flush();
        }
        catch (Throwable throwable) {
            TapestryUtils.close(is);
            throw throwable;
        }
        TapestryUtils.close(is);
    }
}

