/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.tapestry.internal.parser.AttributeToken;
import org.apache.tapestry.internal.parser.BlockToken;
import org.apache.tapestry.internal.parser.BodyToken;
import org.apache.tapestry.internal.parser.CDATAToken;
import org.apache.tapestry.internal.parser.CommentToken;
import org.apache.tapestry.internal.parser.ComponentTemplate;
import org.apache.tapestry.internal.parser.ComponentTemplateImpl;
import org.apache.tapestry.internal.parser.EndElementToken;
import org.apache.tapestry.internal.parser.ExpansionToken;
import org.apache.tapestry.internal.parser.ParameterToken;
import org.apache.tapestry.internal.parser.StartComponentToken;
import org.apache.tapestry.internal.parser.StartElementToken;
import org.apache.tapestry.internal.parser.TemplateToken;
import org.apache.tapestry.internal.parser.TextToken;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.internal.services.TemplateParser;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.LocationImpl;
import org.apache.tapestry.ioc.internal.util.TapestryException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TemplateParserImpl
implements TemplateParser,
LexicalHandler,
ContentHandler {
    private static final String MIXINS_ATTRIBUTE_NAME = "mixins";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String ID_ATTRIBUTE_NAME = "id";
    public static final String TAPESTRY_SCHEMA_5_0_0 = "http://tapestry.apache.org/schema/tapestry_5_0_0.xsd";
    private XMLReader _reader;
    private Resource _templateResource;
    private Locator _locator;
    private final List<TemplateToken> _tokens = CollectionFactory.newList();
    private final Set<String> _componentIds = CollectionFactory.newSet();
    private final StringBuilder _textBuffer = new StringBuilder();
    private Location _textStartLocation;
    private boolean _textIsCData;
    private boolean _insideBody;
    private boolean _insideBodyErrorLogged;
    private boolean _ignoreEvents;
    private final Log _log;
    private final Pattern EXPANSION_PATTERN = Pattern.compile("\\$\\{\\s*(.*?)\\s*}", 8);

    public TemplateParserImpl(Log log) {
        this._log = log;
        this.reset();
    }

    private void reset() {
        this._tokens.clear();
        this._componentIds.clear();
        this._templateResource = null;
        this._locator = null;
        this._textBuffer.setLength(0);
        this._textStartLocation = null;
        this._textIsCData = false;
        this._insideBody = false;
        this._insideBodyErrorLogged = false;
        this._ignoreEvents = true;
    }

    public ComponentTemplate parseTemplate(Resource templateResource) {
        URL resourceURL;
        if (this._reader == null) {
            try {
                this._reader = XMLReaderFactory.createXMLReader();
                this._reader.setContentHandler(this);
                this._reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                this._reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            }
            catch (Exception ex) {
                throw new RuntimeException(ServicesMessages.newParserError(templateResource, ex), ex);
            }
        }
        if ((resourceURL = templateResource.toURL()) == null) {
            throw new RuntimeException(ServicesMessages.missingTemplateResource(templateResource));
        }
        this._templateResource = templateResource;
        try {
            InputSource source = new InputSource(resourceURL.openStream());
            this._reader.parse(source);
            ComponentTemplateImpl componentTemplateImpl = new ComponentTemplateImpl(this._templateResource, this._tokens, this._componentIds);
            return componentTemplateImpl;
        }
        catch (Exception ex) {
            this._reader = null;
            throw new TapestryException(ServicesMessages.templateParseError(templateResource, ex), this.getCurrentLocation(), (Throwable)ex);
        }
        finally {
            this.reset();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._ignoreEvents) {
            return;
        }
        if (this.insideBody()) {
            return;
        }
        if (this._textBuffer.length() == 0) {
            this._textStartLocation = this.getCurrentLocation();
        }
        this._textBuffer.append(ch, start, length);
    }

    private void processTextBuffer() {
        if (this._textBuffer.length() == 0) {
            return;
        }
        String text = this._textBuffer.toString();
        if (this._textIsCData) {
            this._tokens.add(new CDATAToken(text, this._textStartLocation));
        } else {
            this.addTokensForText(text);
        }
        this._textBuffer.setLength(0);
    }

    private void addTokensForText(String text) {
        Matcher matcher = this.EXPANSION_PATTERN.matcher(text);
        int startx = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            if (matchStart != startx) {
                String prefix = text.substring(startx, matchStart);
                this._tokens.add(new TextToken(prefix, this._textStartLocation));
            }
            String expression = matcher.group(1);
            this._tokens.add(new ExpansionToken(expression, this._textStartLocation));
            startx = matcher.end();
        }
        if (startx < text.length()) {
            this._tokens.add(new TextToken(text.substring(startx, text.length()), this._textStartLocation));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this._ignoreEvents = false;
        if (this._insideBody) {
            throw new IllegalStateException(ServicesMessages.mayNotNestElementsInsideBody(localName));
        }
        this.processTextBuffer();
        if (TAPESTRY_SCHEMA_5_0_0.equals(uri)) {
            this.startTapestryElement(qName, localName, attributes);
            return;
        }
        this.startStaticElement(localName, attributes);
    }

    private void startStaticElement(String localName, Attributes attributes) {
        boolean isComponent;
        Location location = this.getCurrentLocation();
        List attributeTokens = CollectionFactory.newList();
        int count = attributes.getLength();
        String id = null;
        String type = null;
        String mixins = null;
        for (int i = 0; i < count; ++i) {
            String name = attributes.getLocalName(i);
            if (InternalUtils.isBlank((String)name)) continue;
            String uri = attributes.getURI(i);
            String value = attributes.getValue(i);
            if (TAPESTRY_SCHEMA_5_0_0.equals(uri) && InternalUtils.isNonBlank((String)value)) {
                if (name.equals(ID_ATTRIBUTE_NAME)) {
                    id = value;
                    continue;
                }
                if (name.equals(TYPE_ATTRIBUTE_NAME)) {
                    type = value;
                    continue;
                }
                if (name.equals(MIXINS_ATTRIBUTE_NAME)) {
                    mixins = value;
                    continue;
                }
            }
            attributeTokens.add(new AttributeToken(name, value, location));
        }
        boolean bl = isComponent = id != null || type != null;
        if (mixins != null && !isComponent) {
            throw new TapestryException(ServicesMessages.mixinsInvalidWithoutIdOrType(localName), location, null);
        }
        if (isComponent) {
            this._tokens.add(new StartComponentToken(localName, id, type, mixins, location));
        } else {
            this._tokens.add(new StartElementToken(localName, location));
        }
        this._tokens.addAll(attributeTokens);
        if (id != null) {
            this._componentIds.add(id);
        }
    }

    private boolean insideBody() {
        if (this._insideBody) {
            if (!this._insideBodyErrorLogged) {
                this._log.error((Object)ServicesMessages.contentInsideBodyNotAllowed(this.getCurrentLocation()));
            }
            this._insideBodyErrorLogged = true;
        }
        return this._insideBody;
    }

    private void startTapestryElement(String qname, String localName, Attributes attributes) {
        if (localName.equals("comp")) {
            this.startComponent(attributes);
            return;
        }
        if (localName.equals("body")) {
            this.startBody();
            return;
        }
        if (localName.equals("parameter")) {
            this.startParameter(attributes);
            return;
        }
        if (localName.equals("block")) {
            this.startBlock(attributes);
            return;
        }
        throw new TapestryException(ServicesMessages.undefinedTapestryElement(qname), this.getCurrentLocation(), null);
    }

    private void startBlock(Attributes attributes) {
        String blockId = this.findSingleParameter("block", ID_ATTRIBUTE_NAME, attributes);
        this._tokens.add(new BlockToken(blockId, this.getCurrentLocation()));
    }

    private void startParameter(Attributes attributes) {
        String parameterName = this.findSingleParameter("parameter", "name", attributes);
        if (InternalUtils.isBlank((String)parameterName)) {
            throw new TapestryException(ServicesMessages.parameterElementNameRequired(), this.getCurrentLocation(), null);
        }
        this._tokens.add(new ParameterToken(parameterName, this.getCurrentLocation()));
    }

    private String findSingleParameter(String elementName, String attributeName, Attributes attributes) {
        String result = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            if (!name.equals(attributeName)) {
                throw new TapestryException(ServicesMessages.undefinedTapestryAttribute(elementName, name, attributeName), this.getCurrentLocation(), null);
            }
            result = attributes.getValue(i);
        }
        return result;
    }

    private void startComponent(Attributes attributes) {
        String id = null;
        String type = null;
        String mixins = null;
        int count = attributes.getLength();
        Location location = this.getCurrentLocation();
        List attributeTokens = CollectionFactory.newList();
        for (int i = 0; i < count; ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if (name.equals(ID_ATTRIBUTE_NAME)) {
                if (!InternalUtils.isNonBlank((String)value)) continue;
                id = value;
                continue;
            }
            if (name.equals(TYPE_ATTRIBUTE_NAME)) {
                if (!InternalUtils.isNonBlank((String)value)) continue;
                type = value;
                continue;
            }
            if (name.equals(MIXINS_ATTRIBUTE_NAME)) {
                if (!InternalUtils.isNonBlank((String)value)) continue;
                mixins = value;
                continue;
            }
            if (name.equals("")) continue;
            attributeTokens.add(new AttributeToken(name, value, location));
        }
        if (id == null && type == null) {
            throw new TapestryException(ServicesMessages.compRequiresIdOrType(), location, null);
        }
        if (id != null) {
            this._componentIds.add(id);
        }
        this._tokens.add(new StartComponentToken(null, id, type, mixins, location));
        this._tokens.addAll(attributeTokens);
    }

    private void startBody() {
        this._tokens.add(new BodyToken(this.getCurrentLocation()));
        this._insideBody = true;
        this._insideBodyErrorLogged = false;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.processTextBuffer();
        if (!this._insideBody) {
            this._tokens.add(new EndElementToken(this.getCurrentLocation()));
        }
        this._insideBody = false;
    }

    private Location getCurrentLocation() {
        if (this._locator == null) {
            return null;
        }
        return new LocationImpl(this._templateResource, this._locator.getLineNumber(), this._locator.getColumnNumber());
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this._ignoreEvents || this.insideBody()) {
            return;
        }
        this.processTextBuffer();
        String comment = new String(ch, start, length).trim();
        this._tokens.add(new CommentToken(comment, this.getCurrentLocation()));
    }

    public void endCDATA() throws SAXException {
        this.processTextBuffer();
        this._textIsCData = false;
    }

    public void startCDATA() throws SAXException {
        if (this._ignoreEvents || this.insideBody()) {
            return;
        }
        this.processTextBuffer();
        this._textIsCData = true;
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

