/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.TransformConstants;

public final class UnclaimedFieldWorker
implements ComponentClassTransformWorker {
    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        List<String> fieldNames = transformation.findUnclaimedFields();
        for (String fieldName : fieldNames) {
            this.transformField(fieldName, transformation);
        }
    }

    private void transformField(String fieldName, ClassTransformation transformation) {
        String type = transformation.getFieldType(fieldName);
        String defaultFieldName = transformation.addField(2, type, fieldName + "_default");
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, defaultFieldName + " = " + fieldName + ";");
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_DETACH_SIGNATURE, fieldName + " = " + defaultFieldName + ";");
    }
}

