/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.structure;

import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.Link;
import org.apache.tapestry.internal.services.LinkFactory;
import org.apache.tapestry.internal.structure.ComponentPageElement;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.internal.structure.StructureMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.runtime.PageLifecycleListener;
import org.apache.tapestry.services.PersistentFieldBundle;
import org.apache.tapestry.services.PersistentFieldManager;

public class PageImpl
implements Page {
    private final String _name;
    private final Locale _locale;
    private final LinkFactory _linkFactory;
    private final PersistentFieldManager _persistentFieldManager;
    private ComponentPageElement _rootElement;
    private final List<PageLifecycleListener> _listeners = CollectionFactory.newList();
    private int _dirtyCount;
    private PersistentFieldBundle _fieldBundle;

    public PageImpl(String name, Locale locale, LinkFactory linkFactory, PersistentFieldManager persistentFieldManager) {
        this._name = name;
        this._locale = locale;
        this._linkFactory = linkFactory;
        this._persistentFieldManager = persistentFieldManager;
    }

    public String toString() {
        return String.format("Page[%s %s]", this._name, this._locale);
    }

    public ComponentPageElement getComponentElementByNestedId(String nestedId) {
        ComponentPageElement element = this._rootElement;
        for (String id : nestedId.split("\\.")) {
            element = element.getEmbeddedElement(id);
        }
        return element;
    }

    public String getName() {
        return this._name;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setRootElement(ComponentPageElement component) {
        this._rootElement = component;
    }

    public ComponentPageElement getRootElement() {
        return this._rootElement;
    }

    public Component getRootComponent() {
        return this._rootElement.getComponent();
    }

    public void addLifecycleListener(PageLifecycleListener listener) {
        this._listeners.add(listener);
    }

    public boolean detached() {
        boolean result = this._dirtyCount > 0;
        for (PageLifecycleListener listener : this._listeners) {
            try {
                listener.containingPageDidDetach();
            }
            catch (RuntimeException ex) {
                this.getLog().error((Object)StructureMessages.detachFailure(listener, ex), (Throwable)ex);
                result = true;
            }
        }
        this._fieldBundle = null;
        return result;
    }

    public void loaded() {
        for (PageLifecycleListener listener : this._listeners) {
            listener.containingPageDidLoad();
        }
    }

    public void attached() {
        if (this._dirtyCount != 0) {
            throw new IllegalStateException(StructureMessages.pageIsDirty(this));
        }
        for (PageLifecycleListener listener : this._listeners) {
            listener.containingPageDidAttach();
        }
    }

    public Log getLog() {
        return this._rootElement.getLog();
    }

    public Link createActionLink(ComponentPageElement element, String action, boolean forForm, Object ... context) {
        return this._linkFactory.createActionLink(element, action, forForm, context);
    }

    public Link createPageLink(String pageName) {
        return this._linkFactory.createPageLink(pageName);
    }

    public void persistFieldChange(ComponentResources resources, String fieldName, Object newValue) {
        this._persistentFieldManager.postChange(this._name, resources, fieldName, newValue);
    }

    public Object getFieldChange(ComponentPageElement element, String fieldName) {
        if (this._fieldBundle == null) {
            this._fieldBundle = this._persistentFieldManager.gatherChanges(this._name);
        }
        return this._fieldBundle.getValue(element.getNestedId(), fieldName);
    }

    public void decrementDirtyCount() {
        --this._dirtyCount;
    }

    public void incrementDirtyCount() {
        ++this._dirtyCount;
    }
}

