/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services;

import java.lang.reflect.Modifier;
import org.apache.tapestry.ioc.internal.util.Defense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSignature
implements Comparable<MethodSignature> {
    private int _hashCode = -1;
    private final int _modifiers;
    private final String _returnType;
    private final String _methodName;
    private final String[] _parameterTypes;
    private final String[] _exceptionTypes;
    private static final String[] EMPTY_STRINGS = new String[0];

    public MethodSignature(String name) {
        this(1, "void", name, EMPTY_STRINGS, EMPTY_STRINGS);
    }

    public MethodSignature(int modifiers, String type, String name, String[] parameterTypes, String[] exceptionTypes) {
        this._modifiers = modifiers;
        this._returnType = Defense.notBlank((String)type, (String)"type");
        this._methodName = Defense.notBlank((String)name, (String)"name");
        this._parameterTypes = this.typeNamesOrEmpty(parameterTypes);
        this._exceptionTypes = this.typeNamesOrEmpty(exceptionTypes);
    }

    private String[] typeNamesOrEmpty(String[] types) {
        return types == null ? EMPTY_STRINGS : types;
    }

    public String[] getExceptionTypes() {
        return this._exceptionTypes;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public String[] getParameterTypes() {
        return this._parameterTypes;
    }

    public String getReturnType() {
        return this._returnType;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            this._hashCode = 17 * this._modifiers;
            this._hashCode += 31 * this._returnType.hashCode();
            this._hashCode += 31 * this._methodName.hashCode();
            for (String parameterType : this._parameterTypes) {
                this._hashCode += 31 * parameterType.hashCode();
            }
            for (String exceptionType : this._exceptionTypes) {
                this._hashCode += 31 * exceptionType.hashCode();
            }
        }
        return this._hashCode;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof MethodSignature)) {
            return false;
        }
        MethodSignature ms = (MethodSignature)other;
        return this._modifiers == ms._modifiers && this._returnType.equals(ms._returnType) && this._methodName.equals(ms._methodName) && this.matches(this._parameterTypes, ms._parameterTypes) && this.matches(this._exceptionTypes, ms._exceptionTypes);
    }

    private boolean matches(String[] values, String[] otherValues) {
        if (values.length != otherValues.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals(otherValues[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this._modifiers != 0) {
            builder.append(Modifier.toString(this._modifiers));
            builder.append(' ');
        }
        builder.append(this._returnType);
        builder.append(' ');
        this.addMethodNameAndParameters(builder);
        for (int i = 0; i < this._exceptionTypes.length; ++i) {
            if (i == 0) {
                builder.append(" throws ");
            } else {
                builder.append(", ");
            }
            builder.append(this._exceptionTypes[i]);
        }
        return builder.toString();
    }

    private void addMethodNameAndParameters(StringBuilder builder) {
        builder.append(this._methodName);
        builder.append('(');
        for (int i = 0; i < this._parameterTypes.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this._parameterTypes[i]);
        }
        builder.append(')');
    }

    @Override
    public int compareTo(MethodSignature o) {
        int result = this._methodName.compareTo(o._methodName);
        if (result == 0) {
            result = this._parameterTypes.length - o._parameterTypes.length;
        }
        return result;
    }

    public String getMediumDescription() {
        StringBuilder builder = new StringBuilder();
        this.addMethodNameAndParameters(builder);
        return builder.toString();
    }
}

