/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.test.pagelevel;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry.dom.Document;
import org.apache.tapestry.dom.Element;
import org.apache.tapestry.dom.Node;
import org.apache.tapestry.internal.TapestryAppInitializer;
import org.apache.tapestry.internal.services.ActionLinkTarget;
import org.apache.tapestry.internal.services.ComponentInvocation;
import org.apache.tapestry.internal.services.LocalizationSetter;
import org.apache.tapestry.internal.services.PageLinkTarget;
import org.apache.tapestry.ioc.Registry;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.util.StrategyRegistry;
import org.apache.tapestry.services.ApplicationGlobals;
import org.apache.tapestry.test.pagelevel.ActionLinkInvoker;
import org.apache.tapestry.test.pagelevel.ComponentInvocationMapForPageTester;
import org.apache.tapestry.test.pagelevel.ComponentInvoker;
import org.apache.tapestry.test.pagelevel.ContextForPageTester;
import org.apache.tapestry.test.pagelevel.CookiesForPageTester;
import org.apache.tapestry.test.pagelevel.FooContextPathSource;
import org.apache.tapestry.test.pagelevel.FormParameterLookupForPageTester;
import org.apache.tapestry.test.pagelevel.NoOpURLEncoder;
import org.apache.tapestry.test.pagelevel.PageLinkInvoker;
import org.apache.tapestry.test.pagelevel.SessionHolderForPageTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageTester
implements ComponentInvoker {
    private Registry _registry;
    private ComponentInvocationMapForPageTester _invocationMap = new ComponentInvocationMapForPageTester();
    private FormParameterLookupForPageTester _formParameterLookup = new FormParameterLookupForPageTester();
    private CookiesForPageTester _cookies;
    private SessionHolderForPageTester _sessionHolder = new SessionHolderForPageTester();
    private StrategyRegistry<ComponentInvoker> _invokerRegistry;
    private Locale _preferedLanguage = Locale.ENGLISH;
    private LocalizationSetter _localizationSetter;
    public static final String DEFAULT_CONTEXT_PATH = "src/main/webapp";
    private final String _contextPath;

    public PageTester(String appPackage, String appName) {
        this(appPackage, appName, DEFAULT_CONTEXT_PATH);
    }

    public PageTester(String appPackage, String appName, String contextPath) {
        this(appPackage, appName, contextPath, Collections.EMPTY_MAP);
    }

    public PageTester(String appPackage, String appName, String contextPath, Map<String, Object> serviceOverrides) {
        this._contextPath = contextPath;
        this._cookies = new CookiesForPageTester();
        this._registry = new TapestryAppInitializer(appPackage, appName, "test", this.addDefaultOverrides(serviceOverrides)).getRegistry();
        this._localizationSetter = (LocalizationSetter)this._registry.getService("tapestry.internal.LocalizationSetter", LocalizationSetter.class);
        ApplicationGlobals globals = (ApplicationGlobals)this._registry.getObject("infrastructure:ApplicationGlobals", ApplicationGlobals.class);
        globals.store(new ContextForPageTester(this._contextPath));
        this.buildInvokersRegistry();
    }

    private void buildInvokersRegistry() {
        Map map = CollectionFactory.newMap();
        map.put(PageLinkTarget.class, new PageLinkInvoker(this._registry));
        map.put(ActionLinkTarget.class, new ActionLinkInvoker(this._registry, this, this._invocationMap));
        this._invokerRegistry = new StrategyRegistry(ComponentInvoker.class, map);
    }

    private Map<String, Object> addDefaultOverrides(Map<String, Object> serviceOverrides) {
        Map modifiedOverrides = CollectionFactory.newMap(serviceOverrides);
        this.addDefaultOverride(modifiedOverrides, "tapestry.internal.ContextPathSource", new FooContextPathSource());
        this.addDefaultOverride(modifiedOverrides, "tapestry.internal.URLEncoder", new NoOpURLEncoder());
        this.addDefaultOverride(modifiedOverrides, "tapestry.internal.ComponentInvocationMap", this._invocationMap);
        this.addDefaultOverride(modifiedOverrides, "tapestry.internal.FormParameterLookup", this._formParameterLookup);
        this.addDefaultOverride(modifiedOverrides, "tapestry.internal.SessionHolder", this._sessionHolder);
        this.addDefaultOverride(modifiedOverrides, "tapestry.internal.CookieSource", this._cookies);
        this.addDefaultOverride(modifiedOverrides, "tapestry.internal.CookieSink", this._cookies);
        return modifiedOverrides;
    }

    private void addDefaultOverride(Map<String, Object> serviceOverrides, String serviceId, Object overridingImpl) {
        if (!serviceOverrides.containsKey(serviceId)) {
            serviceOverrides.put(serviceId, overridingImpl);
        }
    }

    public void shutdown() {
        if (this._registry != null) {
            this._registry.shutdown();
        }
    }

    public Document renderPage(String pageName) {
        return this.invoke(new ComponentInvocation(new PageLinkTarget(pageName), new Object[0]));
    }

    public Document clickLink(Element link) {
        Defense.notNull((Object)link, (String)"link");
        ComponentInvocation invocation = this.getInvocation(link);
        return this.invoke(invocation);
    }

    private ComponentInvocation getInvocation(Element element) {
        ComponentInvocation invocation = this._invocationMap.get(element);
        if (invocation == null) {
            throw new IllegalArgumentException("No component invocation object is associated with the Element");
        }
        return invocation;
    }

    @Override
    public Document invoke(ComponentInvocation invocation) {
        this._invocationMap.clear();
        this.setThreadLocale();
        ComponentInvoker invoker = (ComponentInvoker)this._invokerRegistry.getByInstance((Object)invocation.getTarget());
        return invoker.invoke(invocation);
    }

    private void setThreadLocale() {
        this._localizationSetter.setThreadLocale(this._preferedLanguage);
    }

    public Document submitForm(Element form, Map<String, String> fieldValues) {
        Defense.notNull((Object)form, (String)"form");
        this._formParameterLookup.clear();
        this._formParameterLookup.addFieldValues(fieldValues);
        this.addHiddenFormFields(form);
        ComponentInvocation invocation = this.getInvocation(form);
        return this.invoke(invocation);
    }

    public Document clickSubmit(Element submitButton, Map<String, String> fieldValues) {
        String DEFAULT_SUBMIT_VALUE_ATTRIBUTE = "Submit Query";
        Defense.notNull((Object)submitButton, (String)"submitButton");
        this.assertIsSubmit(submitButton);
        Element form = this.getFormAncestor(submitButton);
        String value = submitButton.getAttribute("value");
        if (value == null) {
            value = "Submit Query";
        }
        fieldValues.put(submitButton.getAttribute("name"), value);
        return this.submitForm(form, fieldValues);
    }

    private void assertIsSubmit(Element element) {
        String type;
        if (element.getName().equals("input") && (type = element.getAttribute("type")) != null && type.equals("submit")) {
            return;
        }
        throw new IllegalArgumentException("The specified element is not a submit button");
    }

    private Element getFormAncestor(Element element) {
        while (true) {
            if (element == null) {
                throw new IllegalArgumentException("The given element is not contained in a form");
            }
            if (element.getName().equalsIgnoreCase("form")) {
                return element;
            }
            element = element.getParent();
        }
    }

    private void addHiddenFormFields(Element element) {
        if (this.isHiddenFormField(element)) {
            this._formParameterLookup.addFieldValue(element.getAttribute("name"), element.getAttribute("value"));
        }
        for (Node child : element.getChildren()) {
            if (!(child instanceof Element)) continue;
            this.addHiddenFormFields((Element)child);
        }
    }

    private boolean isHiddenFormField(Element element) {
        return element.getName().equals("input") && "hidden".equals(element.getAttribute("type"));
    }

    public void setPreferedLanguage(Locale preferedLanguage) {
        this._preferedLanguage = preferedLanguage;
    }
}

