/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.apache.tapestry.ioc.Registry;
import org.apache.tapestry.ioc.RegistryBuilder;

public final class IOCUtilities {
    private IOCUtilities() {
    }

    public static Registry buildDefaultRegistry() {
        RegistryBuilder builder = new RegistryBuilder();
        IOCUtilities.addDefaultModules(builder);
        return builder.build();
    }

    public static void addDefaultModules(RegistryBuilder builder) {
        try {
            Enumeration<URL> urls = builder.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                IOCUtilities.addModulesInManifest(builder, url);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addModulesInManifest(RegistryBuilder builder, URL url) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            Manifest mf = new Manifest(in);
            in.close();
            in = null;
            IOCUtilities.addModulesInManifest(builder, mf);
        }
        finally {
            IOCUtilities.close(in);
        }
    }

    static void addModulesInManifest(RegistryBuilder builder, Manifest mf) {
        String[] classnames;
        String list = mf.getMainAttributes().getValue("Tapestry-Module-Classes");
        if (list == null) {
            return;
        }
        for (String classname : classnames = list.split(",")) {
            builder.add(classname.trim());
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String toQualifiedId(String moduleId, String id) {
        if (id.indexOf(46) > 0) {
            return id;
        }
        return moduleId + "." + id;
    }

    public static String qualifySimpleIdList(String sourceModuleId, String list) {
        if (list == null || list.equals("") || list.equals("*")) {
            return list;
        }
        String[] items = list.split("\\s*,\\s*");
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(IOCUtilities.toQualifiedId(sourceModuleId, items[i]));
        }
        return buffer.toString();
    }

    public static String toSimpleId(String id) {
        int lastPoint = id.lastIndexOf(46);
        if (lastPoint > 0) {
            return id.substring(lastPoint + 1, id.length());
        }
        return id;
    }

    public static String extractModuleId(String id) {
        int lastPoint = id.lastIndexOf(46);
        if (lastPoint > 0) {
            return id.substring(0, lastPoint);
        }
        return null;
    }
}

