/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.LogSource;
import org.apache.tapestry.ioc.Registry;
import org.apache.tapestry.ioc.annotations.SubModule;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.internal.DefaultModuleDefImpl;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.LogSourceImpl;
import org.apache.tapestry.ioc.internal.RegistryImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.services.TapestryIOCModule;

public final class RegistryBuilder {
    private final OneShotLock _lock = new OneShotLock();
    final Map<String, ModuleDef> _modules = CollectionFactory.newMap();
    private final Map<String, Object> _serviceOverrides = CollectionFactory.newMap();
    private final ClassLoader _classLoader;
    private final Log _log;
    private final LogSource _logSource;

    public RegistryBuilder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public RegistryBuilder(ClassLoader classLoader) {
        this(classLoader, new LogSourceImpl());
    }

    public RegistryBuilder(ClassLoader classLoader, LogSource logSource) {
        this._classLoader = classLoader;
        this._logSource = logSource;
        this._log = logSource.getLog(RegistryBuilder.class);
        this.add(TapestryIOCModule.class);
    }

    public void add(ModuleDef moduleDef) {
        this._lock.check();
        String id = moduleDef.getModuleId();
        if (this._modules.containsKey(id)) {
            this._log.warn((Object)IOCMessages.moduleIdConflict(id), null);
            return;
        }
        this._modules.put(id, moduleDef);
    }

    public void add(Class ... moduleBuilderClasses) {
        this._lock.check();
        List queue = CollectionFactory.newList(Arrays.asList(moduleBuilderClasses));
        while (!queue.isEmpty()) {
            Class c = (Class)queue.remove(0);
            DefaultModuleDefImpl def = new DefaultModuleDefImpl(c, this._log);
            this.add(def);
            SubModule annotation = c.getAnnotation(SubModule.class);
            if (annotation == null) continue;
            for (Class sub : annotation.value()) {
                queue.add(sub);
            }
        }
    }

    public void add(String classname) {
        this._lock.check();
        try {
            Class<?> builderClass = Class.forName(classname, true, this._classLoader);
            this.add(builderClass);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Registry build() {
        this._lock.lock();
        return new RegistryImpl(this._modules.values(), this._classLoader, this._logSource, this._serviceOverrides);
    }

    public ClassLoader getClassLoader() {
        this._lock.check();
        return this._classLoader;
    }

    public Log getLog() {
        this._lock.check();
        return this._log;
    }

    public void addServiceOverride(String serviceId, Object overridingImpl) {
        this._serviceOverrides.put(serviceId, overridingImpl);
    }
}

