/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import org.apache.tapestry.ioc.internal.MatchType;

public class GlobPatternMatcher {
    private String _substring;
    private MatchType _type;

    public GlobPatternMatcher(String pattern) {
        this.analyze(pattern);
    }

    private void analyze(String pattern) {
        if (pattern.equals("*")) {
            this._type = MatchType.ANY;
            return;
        }
        boolean globPrefix = pattern.startsWith("*");
        boolean globSuffix = pattern.endsWith("*");
        if (globPrefix && globSuffix) {
            this._substring = pattern.substring(1, pattern.length() - 1);
            this._type = MatchType.INFIX;
            return;
        }
        if (globPrefix) {
            this._substring = pattern.substring(1);
            this._type = MatchType.SUFFIX;
            return;
        }
        if (globSuffix) {
            this._substring = pattern.substring(0, pattern.length() - 1);
            this._type = MatchType.PREFIX;
            return;
        }
        this._type = MatchType.EXACT;
        this._substring = pattern;
    }

    public boolean matches(String input) {
        switch (this._type) {
            case ANY: {
                return true;
            }
            case EXACT: {
                return input.equals(this._substring);
            }
            case INFIX: {
                return input.contains(this._substring);
            }
            case PREFIX: {
                return input.startsWith(this._substring);
            }
        }
        return input.endsWith(this._substring);
    }
}

