/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.util.Collections;
import java.util.List;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ServiceDecorator;
import org.apache.tapestry.ioc.internal.Module;

public class InterceptorStackBuilder
implements ObjectCreator {
    private final String _serviceId;
    private final ObjectCreator _coreServiceCreator;
    private final Module _module;

    public InterceptorStackBuilder(Module module, String serviceId, ObjectCreator coreServiceCreator) {
        this._module = module;
        this._serviceId = serviceId;
        this._coreServiceCreator = coreServiceCreator;
    }

    public Object createObject() {
        Object current = this._coreServiceCreator.createObject();
        List<ServiceDecorator> decorators = this._module.findDecoratorsForService(this._serviceId);
        Collections.reverse(decorators);
        for (ServiceDecorator decorator : decorators) {
            Object interceptor = decorator.createInterceptor(current);
            if (interceptor == null) continue;
            current = interceptor;
        }
        return current;
    }
}

