/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.InternalRegistry;
import org.apache.tapestry.ioc.internal.Module;
import org.apache.tapestry.ioc.internal.ServiceLocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceResourcesImpl
extends ServiceLocatorImpl
implements ServiceBuilderResources {
    private final ServiceDef _serviceDef;
    private Log _log;

    public ServiceResourcesImpl(InternalRegistry registry, Module module, ServiceDef serviceDef, Log log) {
        super(registry, module);
        this._serviceDef = serviceDef;
        this._log = log;
    }

    @Override
    public String getServiceId() {
        return this._serviceDef.getServiceId();
    }

    @Override
    public Class getServiceInterface() {
        return this._serviceDef.getServiceInterface();
    }

    @Override
    public Log getServiceLog() {
        return this._log;
    }

    @Override
    public <T> Collection<T> getUnorderedConfiguration(Class<T> valueType) {
        Collection<T> result = this.getRegistry().getUnorderedConfiguration(this._serviceDef, valueType);
        this.logConfiguration(result);
        return result;
    }

    private void logConfiguration(Collection configuration) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)IOCMessages.constructedConfiguration(configuration));
        }
    }

    @Override
    public <T> List<T> getOrderedConfiguration(Class<T> valueType) {
        List<T> result = this.getRegistry().getOrderedConfiguration(this._serviceDef, valueType);
        this.logConfiguration(result);
        return result;
    }

    @Override
    public <K, V> Map<K, V> getMappedConfiguration(Class<K> keyType, Class<V> valueType) {
        Map<K, V> result = this.getRegistry().getMappedConfiguration(this._serviceDef, keyType, valueType);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)IOCMessages.constructedConfiguration(result));
        }
        return result;
    }

    @Override
    public Object getModuleBuilder() {
        return this.getModule().getModuleBuilder();
    }
}

