/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Map;
import javassist.CtClass;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.internal.services.CtClassSource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.OneShotLock;

public class AbstractFab {
    protected final OneShotLock _lock = new OneShotLock();
    private final CtClass _ctClass;
    private final CtClassSource _source;
    private final Log _log;
    private Map<Class, CtClass> _ctClassCache = CollectionFactory.newMap();

    public AbstractFab(CtClassSource source, CtClass ctClass, Log log) {
        this._ctClass = ctClass;
        this._source = source;
        this._log = log;
    }

    public void addInterface(Class interfaceClass) {
        this._lock.check();
        CtClass ctInterfaceClass = this._source.getCtClass(interfaceClass);
        try {
            for (CtClass existing : this._ctClass.getInterfaces()) {
                if (existing != ctInterfaceClass) continue;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._ctClass.addInterface(ctInterfaceClass);
    }

    protected CtClass[] convertClasses(Class[] inputClasses) {
        if (inputClasses == null || inputClasses.length == 0) {
            return null;
        }
        int count = inputClasses.length;
        CtClass[] result = new CtClass[count];
        for (int i = 0; i < count; ++i) {
            CtClass ctClass;
            result[i] = ctClass = this.convertClass(inputClasses[i]);
        }
        return result;
    }

    protected CtClass convertClass(Class inputClass) {
        CtClass result = this._ctClassCache.get(inputClass);
        if (result == null) {
            result = this._source.getCtClass(inputClass);
            this._ctClassCache.put(inputClass, result);
        }
        return result;
    }

    public Class createClass() {
        this._lock.lock();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)String.format("Creating class from %s", this));
        }
        return this._source.createClass(this._ctClass);
    }

    protected CtClass getCtClass() {
        return this._ctClass;
    }

    protected CtClassSource getSource() {
        return this._source;
    }
}

