/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ChainBuilder;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.MethodIterator;
import org.apache.tapestry.ioc.services.MethodSignature;
import org.apache.tapestry.ioc.util.BodyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainBuilderImpl
implements ChainBuilder {
    private final ClassFactory _classFactory;
    private Map<Class, Class> _cache = CollectionFactory.newThreadSafeMap();

    public ChainBuilderImpl(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    @Override
    public <T> T build(Class<T> commandInterface, List<T> commands) {
        Class chainClass = this.findImplementationClass(commandInterface);
        return this.createInstance(chainClass, commands);
    }

    private Class findImplementationClass(Class commandInterface) {
        Class result = this._cache.get(commandInterface);
        if (result == null) {
            result = this.constructImplementationClass(commandInterface);
            this._cache.put(commandInterface, result);
        }
        return result;
    }

    private Class constructImplementationClass(Class commandInterface) {
        String name = ClassFabUtils.generateClassName(commandInterface);
        ClassFab cf = this._classFactory.newClass(name, Object.class);
        this.addInfrastructure(cf, commandInterface);
        this.addMethods(cf, commandInterface);
        return cf.createClass();
    }

    private void addInfrastructure(ClassFab cf, Class commandInterface) {
        String arrayClassName = commandInterface.getCanonicalName() + "[]";
        String jvmName = ClassFabUtils.getJVMClassName(arrayClassName);
        Class<?> array = null;
        try {
            ClassLoader loader = commandInterface.getClass().getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            array = Class.forName(jvmName, true, loader);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        cf.addInterface(commandInterface);
        cf.addField("_commands", array);
        BodyBuilder builder = new BodyBuilder();
        builder.addln("_commands = (%s[]) $1.toArray(new %<s[0]);", commandInterface.getName());
        cf.addConstructor(new Class[]{List.class}, null, builder.toString());
    }

    private <T> T createInstance(Class<T> instanceClass, List<T> commands) {
        try {
            Constructor<?> ctor = instanceClass.getConstructors()[0];
            return instanceClass.cast(ctor.newInstance(commands));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addMethods(ClassFab cf, Class commandInterface) {
        MethodIterator mi = new MethodIterator(commandInterface);
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            this.addMethod(cf, commandInterface, sig);
        }
        if (!mi.getToString()) {
            cf.addToString(String.format("<Command chain of %s>", commandInterface.getName()));
        }
    }

    private void addMethod(ClassFab cf, Class commandInterface, MethodSignature sig) {
        Class returnType = sig.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            this.addVoidMethod(cf, commandInterface, sig);
            return;
        }
        String defaultValue = this.defaultForReturnType(returnType);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("%s result = %s;", ClassFabUtils.getJavaClassName(returnType), defaultValue);
        builder.addln("for (int i = 0; i < _commands.length; i++)", new Object[0]);
        builder.begin();
        builder.addln("result = _commands[i].%s($$);", sig.getName());
        builder.addln("if (result != %s) break;", defaultValue);
        builder.end();
        builder.addln("return result;", new Object[0]);
        builder.end();
        cf.addMethod(1, sig, builder.toString());
    }

    private String defaultForReturnType(Class returnType) {
        if (!returnType.isPrimitive()) {
            return "null";
        }
        if (returnType.equals(Boolean.TYPE)) {
            return "false";
        }
        return "0";
    }

    private void addVoidMethod(ClassFab cf, Class commandInterface, MethodSignature sig) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("for (int i = 0; i < _commands.length; i++)", new Object[0]);
        builder.addln("  _commands[i].%s($$);", sig.getName());
        builder.end();
        cf.addMethod(1, sig, builder.toString());
    }
}

