/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.lang.reflect.Modifier;
import java.util.Formatter;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.internal.services.AbstractFab;
import org.apache.tapestry.ioc.internal.services.CtClassSource;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.MethodIterator;
import org.apache.tapestry.ioc.services.MethodSignature;

public class ClassFabImpl
extends AbstractFab
implements ClassFab {
    private static final Map<Class, String> DEFAULT_RETURN = CollectionFactory.newMap();
    private final StringBuilder _description = new StringBuilder();
    private final Formatter _formatter = new Formatter(this._description);
    private final Set<MethodSignature> _addedSignatures = CollectionFactory.newSet();

    public ClassFabImpl(CtClassSource source, CtClass ctClass, Log log) {
        super(source, ctClass, log);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("ClassFab[\n");
        try {
            buffer.append(this.buildClassAndInheritance());
            buffer.append(this._description.toString());
        }
        catch (Exception ex) {
            buffer.append(" *** ");
            buffer.append(ex);
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    private String buildClassAndInheritance() throws NotFoundException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Modifier.toString(this.getCtClass().getModifiers()));
        buffer.append(" class ");
        buffer.append(this.getName());
        buffer.append(" extends ");
        buffer.append(this.getCtClass().getSuperclass().getName());
        buffer.append("\n");
        CtClass[] interfaces = this.getCtClass().getInterfaces();
        if (interfaces.length > 0) {
            buffer.append("  implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(interfaces[i].getName());
            }
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    String getName() {
        return this.getCtClass().getName();
    }

    public void addField(String name, Class type) {
        this._lock.check();
        CtClass ctType = this.convertClass(type);
        try {
            CtField field = new CtField(ctType, name, this.getCtClass());
            field.setModifiers(2);
            this.getCtClass().addField(field);
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException(ServiceMessages.unableToAddField(name, this.getCtClass(), ex), ex);
        }
        this._formatter.format("private %s %s;\n\n", ClassFabUtils.getJavaClassName(type), name);
    }

    public void proxyMethodsToDelegate(Class serviceInterface, String delegateExpression, String toString) {
        this._lock.check();
        this.addInterface(serviceInterface);
        MethodIterator mi = new MethodIterator(serviceInterface);
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            String body = String.format("return ($r) %s.%s($$);", delegateExpression, sig.getName());
            this.addMethod(1, sig, body);
        }
        if (!mi.getToString()) {
            this.addToString(toString);
        }
    }

    public void addToString(String toString) {
        this._lock.check();
        MethodSignature sig = new MethodSignature(String.class, "toString", null, null);
        this.addMethod(1, sig, String.format("return \"%s\";", toString));
    }

    public void addMethod(int modifiers, MethodSignature ms, String body) {
        this._lock.check();
        if (this._addedSignatures.contains(ms)) {
            throw new RuntimeException(ServiceMessages.duplicateMethodInClass(ms, this));
        }
        CtClass ctReturnType = this.convertClass(ms.getReturnType());
        CtClass[] ctParameters = this.convertClasses(ms.getParameterTypes());
        CtClass[] ctExceptions = this.convertClasses(ms.getExceptionTypes());
        CtMethod method = new CtMethod(ctReturnType, ms.getName(), ctParameters, this.getCtClass());
        try {
            method.setModifiers(modifiers);
            method.setBody(body);
            method.setExceptionTypes(ctExceptions);
            this.getCtClass().addMethod(method);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToAddMethod(ms, this.getCtClass(), ex), ex);
        }
        this._addedSignatures.add(ms);
        this._formatter.format("%s %s %s", Modifier.toString(modifiers), ClassFabUtils.getJavaClassName(ms.getReturnType()), ms.getName());
        this.addMethodDetailsToDescription(ms.getParameterTypes(), ms.getExceptionTypes(), body);
        this._description.append("\n\n");
    }

    public void addNoOpMethod(MethodSignature signature) {
        this._lock.check();
        Class returnType = signature.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            this.addMethod(1, signature, "return;");
            return;
        }
        String value = "null";
        if (returnType.isPrimitive() && (value = DEFAULT_RETURN.get(returnType)) == null) {
            value = "0";
        }
        this.addMethod(1, signature, "return " + value + ";");
    }

    public void addConstructor(Class[] parameterTypes, Class[] exceptions, String body) {
        Defense.notBlank(body, "body");
        this._lock.check();
        CtClass[] ctParameters = this.convertClasses(parameterTypes);
        CtClass[] ctExceptions = this.convertClasses(exceptions);
        try {
            CtConstructor constructor = new CtConstructor(ctParameters, this.getCtClass());
            constructor.setExceptionTypes(ctExceptions);
            constructor.setBody(body);
            this.getCtClass().addConstructor(constructor);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToAddConstructor(this.getCtClass(), ex), ex);
        }
        this._description.append("public ");
        this._description.append(this.getName());
        this.addMethodDetailsToDescription(parameterTypes, exceptions, body);
        this._description.append("\n\n");
    }

    private void addMethodDetailsToDescription(Class[] parameterTypes, Class[] exceptions, String body) {
        int i;
        this._description.append("(");
        int count = InternalUtils.size(parameterTypes);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                this._description.append(", ");
            }
            this._description.append(ClassFabUtils.getJavaClassName(parameterTypes[i]));
            this._description.append(" $");
            this._description.append(i + 1);
        }
        this._description.append(")");
        count = InternalUtils.size(exceptions);
        for (i = 0; i < count; ++i) {
            if (i == 0) {
                this._description.append("\n  throws ");
            } else {
                this._description.append(", ");
            }
            this._description.append(exceptions[i].getName());
        }
        this._description.append("\n");
        this._description.append(body);
    }

    static {
        DEFAULT_RETURN.put(Boolean.TYPE, "false");
        DEFAULT_RETURN.put(Long.TYPE, "0L");
        DEFAULT_RETURN.put(Float.TYPE, "0.0f");
        DEFAULT_RETURN.put(Double.TYPE, "0.0d");
    }
}

