/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Map;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.services.SymbolSource;
import org.apache.tapestry.ioc.services.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterObjectProvider
implements ObjectProvider {
    private final Map<String, ObjectProvider> _configuration;
    private final SymbolSource _symbolSource;
    private final TypeCoercer _typeCoercer;

    public MasterObjectProvider(Map<String, ObjectProvider> configuration, SymbolSource symbolSource, TypeCoercer typeCoercer) {
        this._configuration = configuration;
        this._symbolSource = symbolSource;
        this._typeCoercer = typeCoercer;
    }

    @Override
    public <T> T provide(String reference, Class<T> objectType, ServiceLocator locator) {
        String expanded = this._symbolSource.expandSymbols(reference);
        int colonx = expanded.indexOf(58);
        if (colonx < 0) {
            return this._typeCoercer.coerce(expanded, objectType);
        }
        String prefix = expanded.substring(0, colonx);
        ObjectProvider provider = this._configuration.get(prefix);
        if (provider == null) {
            throw new RuntimeException(ServiceMessages.unknownObjectProvider(prefix, expanded));
        }
        String expression = expanded.substring(colonx + 1);
        return provider.provide(expression, objectType, locator);
    }
}

