/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.services.PropertyAdapter;

public class PropertyAdapterImpl
implements PropertyAdapter {
    private final String _name;
    private final Method _readMethod;
    private final Method _writeMethod;
    private final Class _type;

    public PropertyAdapterImpl(String name, Class type, Method readMethod, Method writeMethod) {
        this._name = Defense.notBlank(name, "name");
        this._type = Defense.notNull(type, "type");
        this._readMethod = readMethod;
        this._writeMethod = writeMethod;
    }

    public PropertyAdapterImpl(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    public String getName() {
        return this._name;
    }

    public Method getReadMethod() {
        return this._readMethod;
    }

    public Class getType() {
        return this._type;
    }

    public Method getWriteMethod() {
        return this._writeMethod;
    }

    public boolean isRead() {
        return this._readMethod != null;
    }

    public boolean isUpdate() {
        return this._writeMethod != null;
    }

    public Object get(Object instance) {
        if (this._readMethod == null) {
            throw new UnsupportedOperationException(ServiceMessages.readNotSupported(instance, this._name));
        }
        Throwable fail = null;
        try {
            return this._readMethod.invoke(instance, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        throw new RuntimeException(ServiceMessages.readFailure(this._name, instance, fail), fail);
    }

    public void set(Object instance, Object value) {
        if (this._writeMethod == null) {
            throw new UnsupportedOperationException(ServiceMessages.writeNotSupported(instance, this._name));
        }
        Throwable fail = null;
        try {
            this._writeMethod.invoke(instance, value);
            return;
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        throw new RuntimeException(ServiceMessages.writeFailure(this._name, instance, fail), fail);
    }
}

