/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.services.RegistryShutdownHub;
import org.apache.tapestry.ioc.services.RegistryShutdownListener;

public class RegistryShutdownHubImpl
implements RegistryShutdownHub {
    private final OneShotLock _lock = new OneShotLock();
    private final Log _log;
    private final List<RegistryShutdownListener> _listeners = CollectionFactory.newThreadSafeList();

    public RegistryShutdownHubImpl(Log log) {
        this._log = log;
    }

    public void addRegistryShutdownListener(RegistryShutdownListener listener) {
        this._lock.check();
        this._listeners.add(listener);
    }

    public void fireRegistryDidShutdown() {
        this._lock.lock();
        for (RegistryShutdownListener l : this._listeners) {
            try {
                l.registryDidShutdown();
            }
            catch (Exception ex) {
                this._log.error((Object)ServiceMessages.shutdownListenerError(l, ex), (Throwable)ex);
            }
        }
        this._listeners.clear();
    }
}

