/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.services.ExceptionTracker;

public final class ServiceLogger {
    private final Log _log;
    private final ExceptionTracker _exceptionTracker;
    private static final String ENTER = "ENTER";
    private static final String EXIT = " EXIT";
    private static final String FAIL = " FAIL";

    public ServiceLogger(Log log, ExceptionTracker exceptionTracker) {
        this._log = log;
        this._exceptionTracker = exceptionTracker;
    }

    public boolean isDebugEnabled() {
        return this._log.isDebugEnabled();
    }

    public void entry(String name, Object[] arguments) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("[%s] %s(", ENTER, name));
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, arguments[i]);
        }
        buffer.append(")");
        this._log.debug((Object)buffer.toString());
    }

    private void convert(StringBuilder buffer, Object object) {
        if (object == null) {
            buffer.append("null");
            return;
        }
        if (object instanceof String) {
            buffer.append("\"");
            buffer.append(object.toString());
            buffer.append("\"");
            return;
        }
        if (object instanceof Object[]) {
            Object[] values = (Object[])object;
            buffer.append('{');
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                this.convert(buffer, values[i]);
            }
            buffer.append('}');
            return;
        }
        if (object instanceof Iterable) {
            Iterable itr = (Iterable)object;
            boolean first = true;
            buffer.append('[');
            Iterator i = itr.iterator();
            while (i.hasNext()) {
                if (!first) {
                    buffer.append(", ");
                }
                this.convert(buffer, i.next());
                first = false;
            }
            buffer.append(']');
            return;
        }
        buffer.append(object.toString());
    }

    public void exit(String name, Object result) {
        Defense.notNull(name, "name");
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("[%s] %s [", EXIT, name));
        this.convert(buffer, result);
        buffer.append(']');
        this._log.debug((Object)buffer.toString());
    }

    public void voidExit(String name) {
        this._log.debug((Object)String.format("[%s] %s", EXIT, name));
    }

    public void fail(String name, Throwable t) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)String.format("[%s] %s -- %s", FAIL, name, t.getClass().getName()), this._exceptionTracker.exceptionLogged(t) ? null : t);
        }
    }
}

