/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.MethodIterator;
import org.apache.tapestry.ioc.services.MethodSignature;
import org.apache.tapestry.ioc.services.StrategyBuilder;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.ioc.util.StrategyRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategyBuilderImpl
implements StrategyBuilder {
    private final ClassFactory _classFactory;

    public StrategyBuilderImpl(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    @Override
    public <S> S build(StrategyRegistry<S> registry) {
        Class<S> interfaceClass = registry.getAdapterType();
        Class implClass = this.createImplClass(interfaceClass);
        try {
            Object raw = implClass.getConstructors()[0].newInstance(registry);
            return interfaceClass.cast(raw);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Class createImplClass(Class interfaceClass) {
        ClassFab cf = this._classFactory.newClass(interfaceClass);
        String interfaceClassName = interfaceClass.getName();
        cf.addField("_registry", StrategyRegistry.class);
        cf.addConstructor(new Class[]{StrategyRegistry.class}, null, "_registry = $1;");
        BodyBuilder builder = new BodyBuilder();
        MethodIterator mi = new MethodIterator(interfaceClass);
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            builder.clear();
            builder.begin();
            builder.addln("Object selector = $1;", new Object[0]);
            builder.addln("%s adapter = (%<s) _registry.getByInstance(selector);", interfaceClassName);
            builder.addln("return ($r) adapter.%s($$);", sig.getName());
            builder.end();
            cf.addMethod(1, sig, builder.toString());
        }
        if (!mi.getToString()) {
            cf.addToString(String.format("<Strategy for %s>", interfaceClassName));
        }
        return cf.createClass();
    }
}

