/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.tapestry.ioc.Locatable;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.ioc.annotations.Inject;
import org.apache.tapestry.ioc.annotations.InjectService;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalUtils {
    public static final String NAME_PREFIX = "_$";

    private InternalUtils() {
    }

    public static String asString(Method method) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.getDeclaringClass().getName());
        buffer.append(".");
        buffer.append(method.getName());
        buffer.append("(");
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            String name = method.getParameterTypes()[i].getSimpleName();
            int dotx = name.lastIndexOf(46);
            buffer.append(name.substring(dotx + 1));
        }
        return buffer.append(")").toString();
    }

    public static int size(Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static String stripMemberPrefix(String memberName) {
        char ch;
        StringBuilder builder = new StringBuilder(memberName);
        while (NAME_PREFIX.indexOf(ch = builder.charAt(0)) >= 0) {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    public static String createMemberName(String memberName) {
        return NAME_PREFIX + InternalUtils.stripMemberPrefix(memberName);
    }

    public static List<String> toList(Enumeration e) {
        List<String> result = CollectionFactory.newList();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    public static <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        for (Annotation a : annotations) {
            if (!annotationClass.isInstance(a)) continue;
            return (T)((Annotation)annotationClass.cast(a));
        }
        return null;
    }

    private static Object calculateParameterValue(Class parameterType, Annotation[] parameterAnnotations, ServiceLocator locator, Map<Class, Object> parameterDefaults) {
        InjectService is = InternalUtils.findAnnotation(parameterAnnotations, InjectService.class);
        if (is != null) {
            String serviceId = is.value();
            return locator.getService(serviceId, parameterType);
        }
        Inject i = InternalUtils.findAnnotation(parameterAnnotations, Inject.class);
        if (i != null) {
            String reference = i.value();
            return locator.getObject(reference, parameterType);
        }
        Object result = parameterDefaults.get(parameterType);
        if (result == null) {
            result = locator.getService(parameterType);
        }
        return result;
    }

    public static Object[] calculateParametersForMethod(Method method, ServiceLocator locator, Map<Class, Object> parameterDefaults) {
        Class[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        return InternalUtils.calculateParameters(locator, parameterDefaults, parameterTypes, annotations);
    }

    public static Object[] calculateParameters(ServiceLocator locator, Map<Class, Object> parameterDefaults, Class[] parameterTypes, Annotation[][] parameterAnnotations) {
        int parameterCount = parameterTypes.length;
        Object[] parameters = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameters[i] = InternalUtils.calculateParameterValue(parameterTypes[i], parameterAnnotations[i], locator, parameterDefaults);
        }
        return parameters;
    }

    public static String join(List elements) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Object o : elements) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(String.valueOf(o));
            first = false;
        }
        return buffer.toString();
    }

    public static String joinSorted(Collection elements) {
        List list = CollectionFactory.newList();
        for (Object o : elements) {
            list.add(String.valueOf(o));
        }
        Collections.sort(list);
        return InternalUtils.join(list);
    }

    public static boolean isBlank(String input) {
        return input == null || input.length() == 0 || input.trim().length() == 0;
    }

    public static boolean isNonBlank(String input) {
        return !InternalUtils.isBlank(input);
    }

    public static String capitalize(String input) {
        if (input.length() == 0) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static Location locationOf(Object location) {
        if (location == null) {
            return null;
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        if (location instanceof Locatable) {
            return ((Locatable)location).getLocation();
        }
        return null;
    }

    public static List<String> sortedKeys(Map map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List<String> keys = CollectionFactory.newList();
        for (Object o : map.keySet()) {
            keys.add(String.valueOf(o));
        }
        Collections.sort(keys);
        return keys;
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static final boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static final <T> Iterator<T> reverseIterator(List<T> list) {
        final ListIterator<T> normal = list.listIterator(list.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return normal.hasPrevious();
            }

            @Override
            public T next() {
                return normal.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean containsSymbols(String input) {
        return input.contains("${");
    }
}

