/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.util.Formatter;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.Resource;

public final class LocationImpl
implements Location {
    private final Resource _resource;
    private final int _line;
    private final int _column;
    private static final int UNKNOWN = -1;

    public LocationImpl(Resource resource) {
        this(resource, -1);
    }

    public LocationImpl(Resource resource, int line) {
        this(resource, line, -1);
    }

    public LocationImpl(Resource resource, int line, int column) {
        this._resource = resource;
        this._line = line;
        this._column = column;
    }

    public Resource getResource() {
        return this._resource;
    }

    public int getLine() {
        return this._line;
    }

    public int getColumn() {
        return this._column;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this._resource.toString());
        Formatter formatter = new Formatter(buffer);
        if (this._line != -1) {
            formatter.format(", line %d", this._line);
        }
        if (this._column != -1) {
            formatter.format(", column %d", this._column);
        }
        return buffer.toString();
    }
}

