/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.IOCUtilities;
import org.apache.tapestry.ioc.IdMatcher;
import org.apache.tapestry.ioc.Orderable;
import org.apache.tapestry.ioc.internal.IdMatcherImpl;
import org.apache.tapestry.ioc.internal.OrIdMatcher;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.DependencyNode;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.internal.util.UtilMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Orderer<T> {
    private final OneShotLock _lock = new OneShotLock();
    private final Log _log;
    private final List<Orderable> _orderables = CollectionFactory.newList();
    private final Map<String, Orderable<T>> _orderablesById = CollectionFactory.newMap();
    private final Map<String, DependencyNode<T>> _dependencyNodesById = CollectionFactory.newMap();
    private DependencyNode<T> _trailer;
    final DependencyLinker<T> _before = new DependencyLinker<T>(){

        @Override
        public void link(DependencyNode<T> source, DependencyNode<T> target) {
            target.addDependency(source);
        }
    };
    final DependencyLinker<T> _after = new DependencyLinker<T>(){

        @Override
        public void link(DependencyNode<T> source, DependencyNode<T> target) {
            source.addDependency(target);
        }
    };

    public Orderer(Log log) {
        this._log = log;
    }

    public void add(Orderable<T> orderable) {
        this._lock.check();
        String id = orderable.getId();
        if (this._orderablesById.containsKey(id)) {
            this._log.warn((Object)UtilMessages.duplicateOrderer(id), null);
            return;
        }
        this._orderables.add(orderable);
        this._orderablesById.put(id, orderable);
    }

    public void add(String id, T target, String ... constraints) {
        this._lock.check();
        this.add(new Orderable<T>(id, target, constraints));
    }

    public List<T> getOrdered() {
        this._lock.lock();
        this.initializeGraph();
        List result = CollectionFactory.newList();
        for (Orderable<T> orderable : this._trailer.getOrdered()) {
            T target = orderable.getTarget();
            if (target == null) continue;
            result.add(target);
        }
        return result;
    }

    private void initializeGraph() {
        this._trailer = new DependencyNode<Object>(this._log, new Orderable<Object>("*-trailer-*", null, new String[0]));
        this.addNodes();
        this.addDependencies();
    }

    private void addNodes() {
        for (Orderable orderable : this._orderables) {
            DependencyNode node = new DependencyNode(this._log, orderable);
            this._dependencyNodesById.put(orderable.getId(), node);
            this._trailer.addDependency(node);
        }
    }

    private void addDependencies() {
        for (Orderable orderable : this._orderables) {
            this.addDependencies(orderable);
        }
    }

    private void addDependencies(Orderable<T> orderable) {
        String sourceId = orderable.getId();
        for (String constraint : orderable.getConstraints()) {
            this.addDependencies(sourceId, constraint);
        }
    }

    private void addDependencies(String sourceId, String constraint) {
        int colonx = constraint.indexOf(58);
        String type = colonx > 0 ? constraint.substring(0, colonx) : null;
        DependencyLinker<T> linker = null;
        if ("after".equals(type)) {
            linker = this._after;
        } else if ("before".equals(type)) {
            linker = this._before;
        }
        if (linker == null) {
            this._log.warn((Object)UtilMessages.constraintFormat(constraint, sourceId));
            return;
        }
        String patternList = constraint.substring(colonx + 1);
        this.linkNodes(sourceId, patternList, linker);
    }

    private void linkNodes(String sourceId, String patternList, DependencyLinker<T> linker) {
        Collection<DependencyNode<T>> nodes = this.findDependencies(sourceId, patternList);
        DependencyNode<T> source = this._dependencyNodesById.get(sourceId);
        for (DependencyNode<T> target : nodes) {
            linker.link(source, target);
        }
    }

    private Collection<DependencyNode<T>> findDependencies(String sourceId, String patternList) {
        String sourceModuleId = IOCUtilities.extractModuleId(sourceId);
        IdMatcher matcher = this.buildMatcherForPattern(sourceModuleId, patternList);
        List<DependencyNode<T>> result = CollectionFactory.newList();
        for (String id : this._dependencyNodesById.keySet()) {
            if (sourceId.equals(id) || !matcher.matches(id)) continue;
            result.add(this._dependencyNodesById.get(id));
        }
        return result;
    }

    private IdMatcher buildMatcherForPattern(String sourceModuleId, String patternList) {
        List<IdMatcher> matchers = CollectionFactory.newList();
        for (String pattern : patternList.split(",")) {
            IdMatcherImpl matcher = new IdMatcherImpl(IOCUtilities.toQualifiedId(sourceModuleId, pattern.trim()));
            matchers.add(matcher);
        }
        return matchers.size() == 1 ? (IdMatcher)matchers.get(0) : new OrIdMatcher(matchers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface DependencyLinker<T> {
        public void link(DependencyNode<T> var1, DependencyNode<T> var2);
    }
}

