/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.services;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;

public class ClassFabUtils {
    private static long _uid = System.currentTimeMillis();
    private static final Map<String, PrimitiveInfo> PRIMITIVE_INFO = CollectionFactory.newMap();

    private ClassFabUtils() {
    }

    public static synchronized String generateClassName(String baseName) {
        return "$" + baseName + "_" + Long.toHexString(_uid++);
    }

    public static String generateClassName(Class interfaceClass) {
        String name = interfaceClass.getName();
        int dotx = name.lastIndexOf(46);
        return ClassFabUtils.generateClassName(name.substring(dotx + 1));
    }

    public static String getJavaClassName(Class inputClass) {
        if (inputClass.isArray()) {
            return ClassFabUtils.getJavaClassName(inputClass.getComponentType()) + "[]";
        }
        return inputClass.getName();
    }

    public static boolean isToString(Method method) {
        if (!method.getName().equals("toString")) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        return method.getReturnType().equals(String.class);
    }

    private static void add(String primitiveType, String typeCode, Class wrapperType, String unwrapMethod) {
        PRIMITIVE_INFO.put(primitiveType, new PrimitiveInfo(typeCode, wrapperType, unwrapMethod));
    }

    public static String getJVMClassName(String type) {
        if (!type.endsWith("[]")) {
            return type;
        }
        StringBuilder buffer = new StringBuilder();
        while (type.endsWith("[]")) {
            buffer.append("[");
            type = type.substring(0, type.length() - 2);
        }
        PrimitiveInfo pi = PRIMITIVE_INFO.get(type);
        if (pi != null) {
            buffer.append(pi.getTypeCode());
        } else {
            buffer.append("L");
            buffer.append(type);
            buffer.append(";");
        }
        return buffer.toString();
    }

    public static String getUnwrapMethodName(String primitiveTypeName) {
        return PRIMITIVE_INFO.get(primitiveTypeName).getUnwrapMethod();
    }

    public static String getWrapperTypeName(String primitiveType) {
        return PRIMITIVE_INFO.get(primitiveType).getWrapperType().getName();
    }

    public static Class getWrapperType(Class primitiveType) {
        if (primitiveType.isPrimitive()) {
            return PRIMITIVE_INFO.get(primitiveType.getName()).getWrapperType();
        }
        return primitiveType;
    }

    static {
        ClassFabUtils.add("boolean", "Z", Boolean.class, "booleanValue");
        ClassFabUtils.add("short", "S", Short.class, "shortValue");
        ClassFabUtils.add("int", "I", Integer.class, "intValue");
        ClassFabUtils.add("long", "J", Long.class, "longValue");
        ClassFabUtils.add("float", "F", Float.class, "floatValue");
        ClassFabUtils.add("double", "D", Double.class, "doubleValue");
        ClassFabUtils.add("char", "C", Character.class, "charValue");
        ClassFabUtils.add("byte", "B", Byte.class, "byteValue");
    }

    private static class PrimitiveInfo {
        private final String _typeCode;
        private final Class _wrapperType;
        private final String _unwrapMethod;

        public PrimitiveInfo(String typeCode, Class wrapperType, String unwrapMethod) {
            this._typeCode = typeCode;
            this._wrapperType = wrapperType;
            this._unwrapMethod = unwrapMethod;
        }

        public String getTypeCode() {
            return this._typeCode;
        }

        public String getUnwrapMethod() {
            return this._unwrapMethod;
        }

        public Class getWrapperType() {
            return this._wrapperType;
        }
    }
}

