/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.services;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodIterator {
    private boolean _toString;
    private int _index = 0;
    private final int _count;
    private final List<MethodSignature> _signatures;

    public MethodIterator(Class subjectClass) {
        Method[] methods = subjectClass.getMethods();
        Map<String, MethodSignature> map = CollectionFactory.newMap();
        for (int i = 0; i < methods.length; ++i) {
            this.processMethod(methods[i], map);
        }
        this._signatures = CollectionFactory.newList(map.values());
        this._count = this._signatures.size();
    }

    private void processMethod(Method m, Map<String, MethodSignature> map) {
        this._toString |= ClassFabUtils.isToString(m);
        MethodSignature sig = new MethodSignature(m);
        String uid = sig.getUniqueId();
        MethodSignature existing = map.get(uid);
        if (existing == null || sig.isOverridingSignatureOf(existing)) {
            map.put(uid, sig);
        }
    }

    public boolean hasNext() {
        return this._index < this._count;
    }

    public MethodSignature next() {
        if (this._index >= this._count) {
            throw new NoSuchElementException();
        }
        return this._signatures.get(this._index++);
    }

    public boolean getToString() {
        return this._toString;
    }
}

