/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.services;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.ServiceLifecycle;
import org.apache.tapestry.ioc.annotations.Id;
import org.apache.tapestry.ioc.annotations.InjectService;
import org.apache.tapestry.ioc.annotations.Lifecycle;
import org.apache.tapestry.ioc.internal.services.ChainBuilderImpl;
import org.apache.tapestry.ioc.internal.services.DefaultImplementationBuilderImpl;
import org.apache.tapestry.ioc.internal.services.ExceptionAnalyzerImpl;
import org.apache.tapestry.ioc.internal.services.ExceptionTrackerImpl;
import org.apache.tapestry.ioc.internal.services.LoggingDecoratorImpl;
import org.apache.tapestry.ioc.internal.services.MapSymbolProvider;
import org.apache.tapestry.ioc.internal.services.MasterObjectProvider;
import org.apache.tapestry.ioc.internal.services.PerThreadServiceLifecycle;
import org.apache.tapestry.ioc.internal.services.PipelineBuilderImpl;
import org.apache.tapestry.ioc.internal.services.PropertyAccessImpl;
import org.apache.tapestry.ioc.internal.services.PropertyShadowBuilderImpl;
import org.apache.tapestry.ioc.internal.services.ServiceObjectProvider;
import org.apache.tapestry.ioc.internal.services.StrategyBuilderImpl;
import org.apache.tapestry.ioc.internal.services.SymbolSourceImpl;
import org.apache.tapestry.ioc.internal.services.SystemPropertiesSymbolProvider;
import org.apache.tapestry.ioc.internal.services.ThreadLocaleImpl;
import org.apache.tapestry.ioc.internal.services.TypeCoercerImpl;
import org.apache.tapestry.ioc.services.ChainBuilder;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.Coercion;
import org.apache.tapestry.ioc.services.CoercionTuple;
import org.apache.tapestry.ioc.services.DefaultImplementationBuilder;
import org.apache.tapestry.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry.ioc.services.ExceptionTracker;
import org.apache.tapestry.ioc.services.LoggingDecorator;
import org.apache.tapestry.ioc.services.PipelineBuilder;
import org.apache.tapestry.ioc.services.PropertyAccess;
import org.apache.tapestry.ioc.services.PropertyShadowBuilder;
import org.apache.tapestry.ioc.services.ServiceLifecycleSource;
import org.apache.tapestry.ioc.services.StrategyBuilder;
import org.apache.tapestry.ioc.services.SymbolProvider;
import org.apache.tapestry.ioc.services.SymbolSource;
import org.apache.tapestry.ioc.services.ThreadCleanupHub;
import org.apache.tapestry.ioc.services.ThreadLocale;
import org.apache.tapestry.ioc.services.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Id(value="tapestry.ioc")
public final class TapestryIOCModule {
    private final ClassFactory _classFactory;

    public TapestryIOCModule(@InjectService(value="ClassFactory") ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    public LoggingDecorator buildLoggingDecorator(@InjectService(value="ExceptionTracker") ExceptionTracker exceptionTracker) {
        return new LoggingDecoratorImpl(this._classFactory, exceptionTracker);
    }

    public static ServiceLifecycleSource buildServiceLifecycleSource(final Map<String, ServiceLifecycle> configuration) {
        return new ServiceLifecycleSource(){

            public ServiceLifecycle get(String lifecycleName) {
                return (ServiceLifecycle)configuration.get(lifecycleName);
            }
        };
    }

    public void contributeServiceLifecycleSource(MappedConfiguration<String, ServiceLifecycle> configuration, @InjectService(value="ThreadCleanupHub") ThreadCleanupHub threadCleanupHub) {
        configuration.add("perthread", new PerThreadServiceLifecycle(threadCleanupHub, this._classFactory));
    }

    public ChainBuilder buildChainBuilder() {
        return new ChainBuilderImpl(this._classFactory);
    }

    public StrategyBuilder buildStrategyBuilder() {
        return new StrategyBuilderImpl(this._classFactory);
    }

    public static PropertyAccess buildPropertyAccess() {
        return new PropertyAccessImpl();
    }

    public PropertyShadowBuilder buildPropertyShadowBuilder(@InjectService(value="PropertyAccess") PropertyAccess propertyAccess) {
        return new PropertyShadowBuilderImpl(this._classFactory, propertyAccess);
    }

    public PipelineBuilder buildPipelineBuilder(@InjectService(value="DefaultImplementationBuilder") DefaultImplementationBuilder builder) {
        return new PipelineBuilderImpl(this._classFactory, builder);
    }

    public DefaultImplementationBuilder buildDefaultImplementationBuilder() {
        return new DefaultImplementationBuilderImpl(this._classFactory);
    }

    public static ObjectProvider buildMasterObjectProvider(Map<String, ObjectProvider> configuration, @InjectService(value="SymbolSource") SymbolSource symbolSource, @InjectService(value="TypeCoercer") TypeCoercer typeCoercer) {
        return new MasterObjectProvider(configuration, symbolSource, typeCoercer);
    }

    public static void contributeMasterObjectProvider(MappedConfiguration<String, ObjectProvider> configuration) {
        configuration.add("service", new ServiceObjectProvider());
    }

    @Lifecycle(value="perthread")
    public static ExceptionTracker buildExceptionTracker() {
        return new ExceptionTrackerImpl();
    }

    public static ExceptionAnalyzer buildExceptionAnalyzer(@InjectService(value="PropertyAccess") PropertyAccess access) {
        return new ExceptionAnalyzerImpl(access);
    }

    public static TypeCoercer buildTypeCoercer(Collection<CoercionTuple> configuration) {
        return new TypeCoercerImpl(configuration);
    }

    public static void contributeTypeCoercer(Configuration<CoercionTuple> configuration) {
        TapestryIOCModule.add(configuration, Object.class, String.class, new Coercion<Object, String>(){

            @Override
            public String coerce(Object input) {
                return input.toString();
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, String.class, new Coercion<Void, String>(){

            @Override
            public String coerce(Void input) {
                return null;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, List.class, new Coercion<Void, List>(){

            @Override
            public List coerce(Void input) {
                return null;
            }
        });
        TapestryIOCModule.add(configuration, String.class, Double.class, new Coercion<String, Double>(){

            @Override
            public Double coerce(String input) {
                return new Double(input);
            }
        });
        TapestryIOCModule.add(configuration, String.class, BigDecimal.class, new Coercion<String, BigDecimal>(){

            @Override
            public BigDecimal coerce(String input) {
                return new BigDecimal(input);
            }
        });
        TapestryIOCModule.add(configuration, BigDecimal.class, Double.class, new Coercion<BigDecimal, Double>(){

            @Override
            public Double coerce(BigDecimal input) {
                return input.doubleValue();
            }
        });
        TapestryIOCModule.add(configuration, String.class, BigInteger.class, new Coercion<String, BigInteger>(){

            @Override
            public BigInteger coerce(String input) {
                return new BigInteger(input);
            }
        });
        TapestryIOCModule.add(configuration, String.class, Long.class, new Coercion<String, Long>(){

            @Override
            public Long coerce(String input) {
                return new Long(input);
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Byte.class, new Coercion<Long, Byte>(){

            @Override
            public Byte coerce(Long input) {
                return input.byteValue();
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Short.class, new Coercion<Long, Short>(){

            @Override
            public Short coerce(Long input) {
                return input.shortValue();
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Integer.class, new Coercion<Long, Integer>(){

            @Override
            public Integer coerce(Long input) {
                return input.intValue();
            }
        });
        TapestryIOCModule.add(configuration, Number.class, Long.class, new Coercion<Number, Long>(){

            @Override
            public Long coerce(Number input) {
                return input.longValue();
            }
        });
        TapestryIOCModule.add(configuration, Double.class, Float.class, new Coercion<Double, Float>(){

            @Override
            public Float coerce(Double input) {
                return Float.valueOf(input.floatValue());
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Double.class, new Coercion<Long, Double>(){

            @Override
            public Double coerce(Long input) {
                return input.doubleValue();
            }
        });
        TapestryIOCModule.add(configuration, String.class, Boolean.class, new Coercion<String, Boolean>(){

            @Override
            public Boolean coerce(String input) {
                String trimmed = input.trim();
                if (trimmed.equalsIgnoreCase("false") || trimmed.length() == 0) {
                    return false;
                }
                return true;
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Boolean.class, new Coercion<Long, Boolean>(){

            @Override
            public Boolean coerce(Long input) {
                return input != 0L;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, Boolean.class, new Coercion<Void, Boolean>(){

            @Override
            public Boolean coerce(Void input) {
                return false;
            }
        });
        TapestryIOCModule.add(configuration, Collection.class, Boolean.class, new Coercion<Collection, Boolean>(){

            @Override
            public Boolean coerce(Collection input) {
                return !input.isEmpty();
            }
        });
        TapestryIOCModule.add(configuration, Object.class, List.class, new Coercion<Object, List>(){

            @Override
            public List coerce(Object input) {
                return Collections.singletonList(input);
            }
        });
        TapestryIOCModule.add(configuration, Object[].class, List.class, new Coercion<Object[], List>(){

            @Override
            public List coerce(Object[] input) {
                return Arrays.asList(input);
            }
        });
    }

    private static <S, T> void add(Configuration<CoercionTuple> configuration, Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        CoercionTuple<S, T> tuple = new CoercionTuple<S, T>(sourceType, targetType, coercion);
        configuration.add(tuple);
    }

    @Lifecycle(value="perthread")
    public static ThreadLocale buildThreadLocale() {
        return new ThreadLocaleImpl();
    }

    public static SymbolSource buildSymbolSource(List<SymbolProvider> configuration) {
        return new SymbolSourceImpl(configuration);
    }

    public static void contributeSymbolSource(OrderedConfiguration<SymbolProvider> configuration, @InjectService(value="ApplicationDefaults") SymbolProvider applicationDefaults, @InjectService(value="FactoryDefaults") SymbolProvider factoryDefaults) {
        configuration.add("SystemProperties", new SystemPropertiesSymbolProvider(), new String[0]);
        configuration.add("ApplicationDefaults", applicationDefaults, "after:SystemProperties");
        configuration.add("FactoryDefaults", factoryDefaults, "after:ApplicationDefaults");
    }

    public static SymbolProvider buildApplicationDefaults(Map<String, String> configuration) {
        return new MapSymbolProvider(configuration);
    }

    public static SymbolProvider buildFactoryDefaults(Map<String, String> configuration) {
        return new MapSymbolProvider(configuration);
    }
}

