/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.util;

import java.util.Map;
import org.apache.tapestry.ioc.MessageFormatter;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.MessageFormatterImpl;

public abstract class AbstractMessages
implements Messages {
    private Map<String, MessageFormatter> _cache = CollectionFactory.newThreadSafeMap();

    protected abstract String valueForKey(String var1);

    public boolean contains(String key) {
        return this.valueForKey(key) != null;
    }

    public String get(String key) {
        if (this.contains(key)) {
            return this.valueForKey(key);
        }
        return String.format("[[missing key: %s]]", key);
    }

    public MessageFormatter getFormatter(String key) {
        MessageFormatter result = this._cache.get(key);
        if (result == null) {
            result = this.buildMessageFormatter(key);
            this._cache.put(key, result);
        }
        return result;
    }

    private MessageFormatter buildMessageFormatter(String key) {
        String format = this.get(key);
        return new MessageFormatterImpl(format);
    }

    public String format(String key, Object ... args) {
        return this.getFormatter(key).format(args);
    }
}

