/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.spring;

import java.util.Collections;
import java.util.Set;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.def.ServiceDef2;
import org.springframework.context.ApplicationContext;

public class SpringBeanServiceDef
implements ServiceDef2 {
    private final String beanName;
    private final ApplicationContext context;

    public SpringBeanServiceDef(String beanName, ApplicationContext context) {
        this.beanName = beanName;
        this.context = context;
    }

    public boolean isPreventDecoration() {
        return true;
    }

    public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
        return new ObjectCreator(){

            public Object createObject() {
                return SpringBeanServiceDef.this.context.getBean(SpringBeanServiceDef.this.beanName);
            }

            public String toString() {
                return String.format("ObjectCreator<Spring Bean '%s'>", SpringBeanServiceDef.this.beanName);
            }
        };
    }

    public String getServiceId() {
        return this.beanName;
    }

    public Set<Class> getMarkers() {
        return Collections.emptySet();
    }

    public Class getServiceInterface() {
        return this.context.getType(this.beanName);
    }

    public String getServiceScope() {
        return "singleton";
    }

    public boolean isEagerLoad() {
        return false;
    }
}

