/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra;

import java.util.concurrent.TimeUnit;
import org.apache.tephra.snapshot.DefaultSnapshotCodec;
import org.apache.tephra.snapshot.SnapshotCodecV2;
import org.apache.tephra.snapshot.SnapshotCodecV3;
import org.apache.tephra.snapshot.SnapshotCodecV4;

public class TxConstants {
    public static final String PROPERTY_TTL = "dataset.table.ttl";
    public static final long MAX_TX_PER_MS = 1000000L;
    public static final String ALLOW_EMPTY_VALUES_KEY = "data.tx.allow.empty.values";
    public static final boolean ALLOW_EMPTY_VALUES_DEFAULT = false;
    public static final String TX_OPERATION_ATTRIBUTE_KEY = "tephra.tx";
    public static final String OLD_TX_OPERATION_ATTRIBUTE_KEY = "cask.tx";
    public static final String TX_ROLLBACK_ATTRIBUTE_KEY = "tephra.tx.rollback";
    public static final String OLD_TX_ROLLBACK_ATTRIBUTE_KEY = "cask.tx.rollback";
    public static final byte[] FAMILY_DELETE_QUALIFIER = new byte[0];
    public static final String STATUS_OK = "OK";
    public static final String STATUS_NOTOK = "NOTOK";
    public static final String READ_NON_TX_DATA = "data.tx.read.pre.existing";
    public static final boolean DEFAULT_READ_NON_TX_DATA = false;
    public static final String CLIENT_ID = "tephra.client.id";

    public static final class TransactionPruning {
        public static final String PRUNE_ENABLE = "data.tx.prune.enable";
        public static final String PRUNE_STATE_TABLE = "data.tx.prune.state.table";
        public static final String PRUNE_INTERVAL = "data.tx.prune.interval";
        public static final String PRUNE_FLUSH_INTERVAL = "data.tx.prune.flush.interval";
        public static final String PRUNE_GRACE_PERIOD = "data.tx.grace.period";
        public static final String PLUGINS = "data.tx.prune.plugins";
        public static final String PLUGIN_CLASS_SUFFIX = ".class";
        public static final boolean DEFAULT_PRUNE_ENABLE = false;
        public static final String DEFAULT_PRUNE_STATE_TABLE = "tephra.state";
        public static final long DEFAULT_PRUNE_INTERVAL = TimeUnit.HOURS.toSeconds(6L);
        public static final long DEFAULT_PRUNE_FLUSH_INTERVAL = TimeUnit.MINUTES.toSeconds(1L);
        public static final long DEFAULT_PRUNE_GRACE_PERIOD = TimeUnit.HOURS.toSeconds(24L);
        public static final String DEFAULT_PLUGIN = "data.tx.prune.plugin.default";
        public static final String DEFAULT_PLUGIN_CLASS = "org.apache.tephra.hbase.txprune.HBaseTransactionPruningPlugin";
    }

    public static final class TransactionLog {
        public static final String NUM_ENTRIES_APPENDED = "count";
        public static final String VERSION_KEY = "version";
        public static final byte CURRENT_VERSION = 3;
        public static final String CFG_SLOW_APPEND_THRESHOLD = "data.tx.log.slow.append.threshold";
        public static final long DEFAULT_SLOW_APPEND_THRESHOLD = 1000L;
    }

    public static final class Persist {
        public static final String CFG_TX_SNAPHOT_CODEC_CLASSES = "data.tx.snapshot.codecs";
        public static final Class[] DEFAULT_TX_SNAPHOT_CODEC_CLASSES = new Class[]{DefaultSnapshotCodec.class, SnapshotCodecV2.class, SnapshotCodecV3.class, SnapshotCodecV4.class};
    }

    public static final class HBase {
        public static final String ZOOKEEPER_QUORUM = "hbase.zookeeper.quorum";
        public static final String ZK_SESSION_TIMEOUT = "zookeeper.session.timeout";
        public static final int DEFAULT_ZK_SESSION_TIMEOUT = 180000;
    }

    public static final class Metrics {
        public static final String REPORT_PERIOD_KEY = "data.tx.metrics.period";
        public static final int REPORT_PERIOD_DEFAULT = 60;
    }

    public static final class Service {
        public static final String CFG_DATA_TX_ZOOKEEPER_QUORUM = "data.tx.zookeeper.quorum";
        public static final String CFG_DATA_TX_DISCOVERY_SERVICE_NAME = "data.tx.discovery.service.name";
        public static final String CFG_DATA_TX_BIND_PORT = "data.tx.bind.port";
        public static final String CFG_DATA_TX_BIND_ADDRESS = "data.tx.bind.address";
        public static final String CFG_DATA_TX_SERVER_IO_THREADS = "data.tx.server.io.threads";
        public static final String CFG_DATA_TX_SERVER_THREADS = "data.tx.server.threads";
        public static final String CFG_DATA_TX_THRIFT_MAX_READ_BUFFER = "data.tx.thrift.max.read.buffer";
        public static final String DEFAULT_DATA_TX_DISCOVERY_SERVICE_NAME = "transaction";
        public static final int DEFAULT_DATA_TX_BIND_PORT = 15165;
        public static final String DEFAULT_DATA_TX_BIND_ADDRESS = "0.0.0.0";
        public static final int DEFAULT_DATA_TX_SERVER_IO_THREADS = 2;
        public static final int DEFAULT_DATA_TX_SERVER_THREADS = 20;
        public static final int DEFAULT_DATA_TX_THRIFT_MAX_READ_BUFFER = 0x1000000;
        public static final String CFG_DATA_TX_CLIENT_TIMEOUT = "data.tx.client.timeout";
        public static final String CFG_DATA_TX_CLIENT_PROVIDER = "data.tx.client.provider";
        public static final String CFG_DATA_TX_CLIENT_COUNT = "data.tx.client.count";
        public static final String CFG_DATA_TX_CLIENT_OBTAIN_TIMEOUT_MS = "data.tx.client.obtain.timeout";
        public static final String CFG_DATA_TX_CLIENT_RETRY_STRATEGY = "data.tx.client.retry.strategy";
        public static final String CFG_DATA_TX_CLIENT_ATTEMPTS = "data.tx.client.retry.attempts";
        public static final String CFG_DATA_TX_CLIENT_BACKOFF_INITIAL = "data.tx.client.retry.backoff.initial";
        public static final String CFG_DATA_TX_CLIENT_BACKOFF_FACTOR = "data.tx.client.retry.backoff.factor";
        public static final String CFG_DATA_TX_CLIENT_BACKOFF_LIMIT = "data.tx.client.retry.backoff.limit";
        public static final int DEFAULT_DATA_TX_CLIENT_TIMEOUT_MS = 30000;
        public static final int DEFAULT_DATA_TX_CLIENT_COUNT = 50;
        public static final long DEFAULT_DATA_TX_CLIENT_OBTAIN_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(3L);
        public static final String DEFAULT_DATA_TX_CLIENT_PROVIDER = "pool";
        public static final String DEFAULT_DATA_TX_CLIENT_RETRY_STRATEGY = "backoff";
        public static final int DEFAULT_DATA_TX_CLIENT_ATTEMPTS = 2;
        public static final int DEFAULT_DATA_TX_CLIENT_BACKOFF_INITIAL = 100;
        public static final int DEFAULT_DATA_TX_CLIENT_BACKOFF_FACTOR = 4;
        public static final int DEFAULT_DATA_TX_CLIENT_BACKOFF_LIMIT = 30000;
    }

    public static final class Manager {
        public static final String CFG_DO_PERSIST = "tx.persist";
        public static final String CFG_TX_SNAPSHOT_DIR = "data.tx.snapshot.dir";
        public static final String CFG_TX_SNAPSHOT_LOCAL_DIR = "data.tx.snapshot.local.dir";
        public static final String CFG_TX_CLEANUP_INTERVAL = "data.tx.cleanup.interval";
        public static final String CFG_TX_HDFS_USER = "data.tx.hdfs.user";
        public static final int DEFAULT_TX_CLEANUP_INTERVAL = 10;
        public static final String CFG_TX_TIMEOUT = "data.tx.timeout";
        public static final int DEFAULT_TX_TIMEOUT = 30;
        public static final String CFG_TX_LONG_TIMEOUT = "data.tx.long.timeout";
        public static final int DEFAULT_TX_LONG_TIMEOUT = (int)TimeUnit.DAYS.toSeconds(1L);
        public static final String CFG_TX_MAX_TIMEOUT = "data.tx.max.timeout";
        public static final int DEFAULT_TX_MAX_TIMEOUT = Integer.MAX_VALUE;
        public static final String CFG_TX_MAX_LIFETIME = "data.tx.max.lifetime";
        public static final int DEFAULT_TX_MAX_LIFETIME = (int)TimeUnit.HOURS.toSeconds(25L);
        public static final String CFG_TX_SNAPSHOT_INTERVAL = "data.tx.snapshot.interval";
        public static final long DEFAULT_TX_SNAPSHOT_INTERVAL = 300L;
        public static final String CFG_TX_SNAPSHOT_RETAIN = "data.tx.snapshot.retain";
        public static final int DEFAULT_TX_SNAPSHOT_RETAIN = 10;
        public static final String CFG_TX_CHANGESET_COUNT_LIMIT = "data.tx.changeset.count.limit";
        public static final String CFG_TX_CHANGESET_COUNT_WARN_THRESHOLD = "data.tx.changeset.count.warn.threshold";
        public static final String CFG_TX_CHANGESET_SIZE_LIMIT = "data.tx.changeset.size.limit";
        public static final String CFG_TX_CHANGESET_SIZE_WARN_THRESHOLD = "data.tx.changeset.size.warn.threshold";
        public static final int DEFAULT_TX_CHANGESET_COUNT_LIMIT = Integer.MAX_VALUE;
        public static final int DEFAULT_TX_CHANGESET_COUNT_WARN_THRESHOLD = Integer.MAX_VALUE;
        public static final long DEFAULT_TX_CHANGESET_SIZE_LIMIT = Long.MAX_VALUE;
        public static final long DEFAULT_TX_CHANGESET_SIZE_WARN_THRESHOLD = Long.MAX_VALUE;
        public static final String CFG_TX_RETAIN_CLIENT_ID = "data.tx.retain.client.id";
        public static final String DEFAULT_TX_RETAIN_CLIENT_ID = "COMMITTED";
    }

    public static enum ConflictDetection {
        ROW,
        COLUMN,
        NONE;

    }
}

